/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.ZoomEvent;
import org.eclipse.gef4.fx.gestures.FXPinchSpreadGesture;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnPinchSpreadPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXPinchSpreadTool
extends AbstractTool<Node> {
    public static final Class<AbstractFXOnPinchSpreadPolicy> TOOL_POLICY_KEY = AbstractFXOnPinchSpreadPolicy.class;
    private final Map<IViewer<Node>, FXPinchSpreadGesture> gestures = new HashMap<IViewer<Node>, FXPinchSpreadGesture>();

    protected Set<? extends AbstractFXOnPinchSpreadPolicy> getPinchSpreadPolicies(IVisualPart<Node, ? extends Node> targetPart) {
        return new HashSet(targetPart.getAdapters(TOOL_POLICY_KEY).values());
    }

    protected Set<? extends AbstractFXOnPinchSpreadPolicy> getTargetPolicies(IViewer<Node> viewer, ZoomEvent e) {
        EventTarget target = e.getTarget();
        if (!(target instanceof Node)) {
            return null;
        }
        Node targetNode = (Node)target;
        IRootPart targetPart = FXPartUtils.getTargetPart(Collections.singleton(viewer), targetNode, TOOL_POLICY_KEY, true);
        if (targetPart == null) {
            targetPart = viewer.getRootPart();
        }
        return this.getPinchSpreadPolicies((IVisualPart<Node, ? extends Node>)targetPart);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            FXPinchSpreadGesture gesture = new FXPinchSpreadGesture(){

                protected void zoom(ZoomEvent e) {
                    FXPinchSpreadTool.this.getDomain().openExecutionTransaction((ITool)FXPinchSpreadTool.this);
                    for (AbstractFXOnPinchSpreadPolicy abstractFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getTargetPolicies((IViewer<Node>)viewer, e)) {
                        abstractFXOnPinchSpreadPolicy.zoom(e);
                    }
                }

                protected void zoomFinished(ZoomEvent e) {
                    for (AbstractFXOnPinchSpreadPolicy abstractFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getTargetPolicies((IViewer<Node>)viewer, e)) {
                        abstractFXOnPinchSpreadPolicy.zoomFinished(e);
                    }
                }

                protected void zoomStarted(ZoomEvent e) {
                    for (AbstractFXOnPinchSpreadPolicy abstractFXOnPinchSpreadPolicy : FXPinchSpreadTool.this.getTargetPolicies((IViewer<Node>)viewer, e)) {
                        abstractFXOnPinchSpreadPolicy.zoomStarted(e);
                    }
                    FXPinchSpreadTool.this.getDomain().closeExecutionTransaction((ITool)FXPinchSpreadTool.this);
                }
            };
            gesture.setScene(((FXViewer)viewer).getScene());
            this.gestures.put((IViewer<Node>)viewer, gesture);
        }
    }

    protected void unregisterListeners() {
        for (FXPinchSpreadGesture gesture : this.gestures.values()) {
            gesture.setScene(null);
        }
        super.unregisterListeners();
    }
}

