/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef4.common.dispose.IDisposable;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.behaviors.ContentPartPool;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IContentPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;

public class ContentBehavior<VR>
extends AbstractBehavior<VR>
implements PropertyChangeListener,
IDisposable {
    @Inject
    private IContentPartFactory<VR> contentPartFactory;
    @Inject
    private ContentPartPool<VR> contentPartPool;

    @Override
    public void activate() {
        super.activate();
        if (this.getHost() == this.getHost().getRoot()) {
            ContentModel contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
            this.synchronizeContentChildren(contentModel.getContents());
            contentModel.addPropertyChangeListener(this);
        } else {
            this.synchronizeContentChildren(((IContentPart)this.getHost()).getContentChildren());
            this.synchronizeContentAnchorages(((IContentPart)this.getHost()).getContentAnchorages());
            this.getHost().addPropertyChangeListener(this);
        }
    }

    @Override
    public void deactivate() {
        if (this.getHost() == this.getHost().getRoot()) {
            ((ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class)).removePropertyChangeListener(this);
            this.synchronizeContentChildren(Collections.emptyList());
        } else {
            this.getHost().removePropertyChangeListener(this);
            this.synchronizeContentAnchorages((SetMultimap<Object, String>)HashMultimap.create());
            this.synchronizeContentChildren(Collections.emptyList());
        }
        super.deactivate();
    }

    public void dispose() {
        this.contentPartPool.clear();
    }

    protected void disposeIfObsolete(IContentPart<VR, ? extends VR> contentPart) {
        if (contentPart.getParent() == null && contentPart.getAnchoreds().isEmpty()) {
            this.contentPartPool.add(contentPart);
            contentPart.setContent(null);
        }
    }

    protected IContentPart<VR, ? extends VR> findOrCreatePartFor(Object content) {
        Map contentPartMap = this.getHost().getRoot().getViewer().getContentPartMap();
        if (contentPartMap.containsKey(content)) {
            return contentPartMap.get(content);
        }
        IContentPart<VR, VR> contentPart = null;
        contentPart = this.contentPartPool.remove(content);
        if (contentPart == null) {
            this.switchAdaptableScopes();
            contentPart = this.contentPartFactory.createContentPart(content, this, Collections.<Object, Object>emptyMap());
            if (contentPart == null) {
                throw new IllegalStateException("IContentPartFactory '" + this.contentPartFactory.getClass().getSimpleName() + "' did not create part for " + content + ".");
            }
        }
        contentPart.setContent(content);
        return contentPart;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("contents".equals(event.getPropertyName())) {
            this.synchronizeContentChildren((List)event.getNewValue());
            ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter(SelectionModel.class)).deselectAll();
            ((HoverModel)this.getHost().getRoot().getViewer().getAdapter(HoverModel.class)).clearHover();
        } else if ("content".equals(event.getPropertyName())) {
            this.synchronizeContentChildren(((IContentPart)this.getHost()).getContentChildren());
            this.synchronizeContentAnchorages(((IContentPart)this.getHost()).getContentAnchorages());
        }
    }

    public void synchronizeContentAnchorages(SetMultimap<? extends Object, String> contentAnchorages) {
        SetMultimap anchorages = this.getHost().getAnchorages();
        ArrayList<Map.Entry> toRemove = new ArrayList<Map.Entry>();
        Set entries = anchorages.entries();
        for (Map.Entry e : entries) {
            Object content;
            if (!(e.getKey() instanceof IContentPart) || contentAnchorages.containsEntry(content = ((IContentPart)e.getKey()).getContent(), e.getValue())) continue;
            toRemove.add(e);
        }
        for (Map.Entry e : toRemove) {
            this.getHost().removeAnchorage((IVisualPart)e.getKey(), (String)e.getValue());
            this.disposeIfObsolete((IContentPart)e.getKey());
        }
        ArrayList<Map.Entry> toAdd = new ArrayList<Map.Entry>();
        for (Map.Entry e : contentAnchorages.entries()) {
            IContentPart<VR, VR> anchorage = this.findOrCreatePartFor(e.getKey());
            if (anchorages.containsEntry(anchorage, e.getValue())) continue;
            toAdd.add(Maps.immutableEntry(anchorage, (Object)((String)e.getValue())));
        }
        for (Map.Entry e : toAdd) {
            this.getHost().addAnchorage((IVisualPart)e.getKey(), (String)e.getValue());
        }
    }

    public void synchronizeContentChildren(List<? extends Object> contentChildren) {
        List<IContentPart> childContentParts = PartUtils.filterParts(this.getHost().getChildren(), IContentPart.class);
        HashMap<Object, IContentPart> contentPartMap = new HashMap<Object, IContentPart>();
        HashSet<? extends Object> newContents = new HashSet<Object>(contentChildren);
        ArrayList<IContentPart> toRemove = new ArrayList<IContentPart>();
        for (IContentPart iContentPart : childContentParts) {
            contentPartMap.put(iContentPart.getContent(), iContentPart);
            if (newContents.contains(iContentPart.getContent())) continue;
            toRemove.add(iContentPart);
        }
        childContentParts.removeAll(toRemove);
        for (IContentPart iContentPart : toRemove) {
            this.getHost().removeChild(iContentPart);
            this.disposeIfObsolete(iContentPart);
        }
        int contentChildrenSize = contentChildren.size();
        int childContentPartsSize = childContentParts.size();
        int i = 0;
        while (i < contentChildrenSize) {
            Object object = contentChildren.get(i);
            if (i >= childContentPartsSize || childContentParts.get(i).getContent() != object) {
                IContentPart<VR, VR> contentPart = (IContentPart<VR, VR>)contentPartMap.get(object);
                if (contentPart != null) {
                    this.getHost().reorderChild(contentPart, i);
                } else {
                    contentPart = this.findOrCreatePartFor(object);
                    if (contentPart.getParent() != null) {
                        throw new IllegalStateException("Located a ContentPart which controls the same (or an equal) content element but is already bound to a parent. A content element may only be controlled by a single ContentPart.");
                    }
                    this.getHost().addChild(contentPart, i);
                }
            }
            ++i;
        }
    }
}

