/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.ChangeHoverOperation;
import org.eclipse.gef4.mvc.operations.ChangeSelectionOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class ClearHoverFocusSelectionOperation<VR>
extends ReverseUndoCompositeOperation {
    public ClearHoverFocusSelectionOperation(IViewer<VR> viewer) {
        super("Clear Hover, Focus, Selection");
        ChangeSelectionOperation<VR> changeSelectionOperation;
        ChangeFocusOperation<VR> changeFocusOperation;
        ChangeHoverOperation<VR> changeHoverOperation = this.getChangeHoverOperation(viewer);
        if (changeHoverOperation != null) {
            this.add((IUndoableOperation)changeHoverOperation);
        }
        if ((changeFocusOperation = this.getChangeFocusOperation(viewer)) != null) {
            this.add((IUndoableOperation)changeFocusOperation);
        }
        if ((changeSelectionOperation = this.getChangeSelectionOperation(viewer)) != null) {
            this.add((IUndoableOperation)changeSelectionOperation);
        }
    }

    private IContentPart<VR, ? extends VR> findNewFocus(Collection<IContentPart<VR, ? extends VR>> isSelected, IContentPart<VR, ? extends VR> part) {
        if (isSelected.contains(part)) {
            return null;
        }
        List<IContentPart> contentPartChildren = PartUtils.filterParts(part.getChildren(), IContentPart.class);
        if (contentPartChildren.isEmpty()) {
            return part;
        }
        for (IContentPart child : contentPartChildren) {
            IContentPart<? extends VR, ? extends VR> newFocus = this.findNewFocus(isSelected, child);
            if (newFocus == null) continue;
            return newFocus;
        }
        return null;
    }

    protected ChangeFocusOperation<VR> getChangeFocusOperation(IViewer<VR> viewer) {
        List<IContentPart<VR, ? extends VR>> isSelected = ((SelectionModel)viewer.getAdapter(SelectionModel.class)).getSelected();
        for (Object object : ((ContentModel)viewer.getAdapter(ContentModel.class)).getContents()) {
            IContentPart<VR, VR> part = viewer.getContentPartMap().get(object);
            IContentPart<? extends VR, ? extends VR> newFocus = this.findNewFocus(isSelected, part);
            if (newFocus == null) continue;
            return new ChangeFocusOperation<VR>(viewer, newFocus);
        }
        return new ChangeFocusOperation<VR>(viewer, null);
    }

    protected ChangeHoverOperation<VR> getChangeHoverOperation(IViewer<VR> viewer) {
        IVisualPart hover = ((HoverModel)viewer.getAdapter(HoverModel.class)).getHover();
        ChangeHoverOperation<VR> changeHoverOperation = null;
        if (hover != null) {
            changeHoverOperation = new ChangeHoverOperation<VR>(viewer, null);
        }
        return changeHoverOperation;
    }

    protected ChangeSelectionOperation<VR> getChangeSelectionOperation(IViewer<VR> viewer) {
        return new ChangeSelectionOperation(viewer, Collections.emptyList());
    }
}

