/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactional;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.policies.AbstractPolicy;
import org.eclipse.gef4.mvc.policies.ContentPolicy;

public class CreationPolicy<VR>
extends AbstractPolicy<VR>
implements ITransactional {
    private List<Map.Entry<IContentPart<VR, ? extends VR>, Object>> contentToCreate;

    @Override
    public IUndoableOperation commit() {
        ForwardUndoCompositeOperation fwd = new ForwardUndoCompositeOperation("Create Content");
        for (Map.Entry<IContentPart<VR, VR>, Object> entry : this.contentToCreate) {
            IContentPart<VR, ? extends VR> parent = entry.getKey();
            Object content = entry.getValue();
            ContentPolicy contentPolicy = (ContentPolicy)parent.getAdapter(ContentPolicy.class);
            if (contentPolicy == null) {
                throw new IllegalStateException("No ContentPolicy registered for <" + parent + ">.");
            }
            int index = parent.getContentChildren().size();
            contentPolicy.init();
            contentPolicy.addContentChild(content, index);
            fwd.add(contentPolicy.commit());
        }
        return fwd.unwrap();
    }

    public void create(IContentPart<VR, ? extends VR> parent, Object content) {
        if (content == null) {
            throw new IllegalArgumentException("The given content may not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The given parent may not be null.");
        }
        this.contentToCreate.add(new AbstractMap.SimpleEntry<IContentPart<VR, ? extends VR>, Object>(parent, content));
    }

    @Override
    public void init() {
        this.contentToCreate = new ArrayList<Map.Entry<IContentPart<VR, ? extends VR>, Object>>();
    }
}

