/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.ui.jface;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.embed.swt.FXCanvas;
import javafx.embed.swt.SWTFXUtils;
import javafx.scene.Node;
import javafx.scene.image.Image;
import org.eclipse.gef4.fx.nodes.IFXDecoration;
import org.eclipse.gef4.fx.ui.canvas.FXCanvasEx;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.ui.parts.SelectionForwarder;
import org.eclipse.gef4.mvc.fx.ui.viewer.FXCanvasSceneContainer;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.fx.viewer.ISceneContainer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.ZestFxModule;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.ui.ZestFxUiModule;
import org.eclipse.gef4.zest.fx.ui.jface.IEdgeDecorationProvider;
import org.eclipse.gef4.zest.fx.ui.jface.IGraphNodeContentProvider;
import org.eclipse.gef4.zest.fx.ui.jface.IGraphNodeLabelProvider;
import org.eclipse.gef4.zest.fx.ui.jface.INestedGraphContentProvider;
import org.eclipse.gef4.zest.fx.ui.jface.INestedGraphLabelProvider;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ZestContentViewer
extends ContentViewer {
    private Module module;
    private FXCanvas canvas;
    private FXDomain domain;
    private FXViewer viewer;
    private ISelection selection;
    private SelectionForwarder<Node> selectionForwarder;
    private ILayoutAlgorithm layoutAlgorithm;
    private Map<Object, org.eclipse.gef4.graph.Node> contentNodeMap = new IdentityHashMap<Object, org.eclipse.gef4.graph.Node>();

    public ZestContentViewer() {
        this.module = this.createModule();
    }

    public ZestContentViewer(Module module) {
        this.module = module;
    }

    protected FXCanvas createCanvas(Composite parent) {
        return new FXCanvasEx(parent, 0);
    }

    public void createControl(Composite parent, int style) {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.module});
        injector.injectMembers((Object)this);
        this.canvas = this.createCanvas(parent);
        this.domain = (FXDomain)injector.getInstance(FXDomain.class);
        this.viewer = (FXViewer)this.domain.getAdapter(IViewer.class);
        this.viewer.setSceneContainer((ISceneContainer)new FXCanvasSceneContainer(this.canvas));
        this.domain.activate();
        this.selectionForwarder = new SelectionForwarder((ISelectionProvider)this, (IViewer)this.viewer);
    }

    protected Edge createEdge(ILabelProvider labelProvider, Object contentSourceNode, org.eclipse.gef4.graph.Node sourceNode, Object contentTargetNode, org.eclipse.gef4.graph.Node targetNode) {
        IGraphNodeLabelProvider graphNodeLabelProvider;
        Map<String, Object> edgeAttributes;
        Edge edge = new Edge(sourceNode, targetNode);
        if (labelProvider instanceof IEdgeDecorationProvider) {
            IFXDecoration targetDecoration;
            IEdgeDecorationProvider edgeDecorationProvider = (IEdgeDecorationProvider)labelProvider;
            IFXDecoration sourceDecoration = edgeDecorationProvider.getSourceDecoration(contentSourceNode, contentTargetNode);
            if (sourceDecoration != null) {
                ZestProperties.setSourceDecoration((Edge)edge, (IFXDecoration)sourceDecoration);
            }
            if ((targetDecoration = edgeDecorationProvider.getTargetDecoration(contentSourceNode, contentTargetNode)) != null) {
                ZestProperties.setTargetDecoration((Edge)edge, (IFXDecoration)targetDecoration);
            }
        }
        if (labelProvider instanceof IGraphNodeLabelProvider && (edgeAttributes = (graphNodeLabelProvider = (IGraphNodeLabelProvider)labelProvider).getEdgeAttributes(contentSourceNode, contentTargetNode)) != null) {
            edge.getAttrs().putAll(edgeAttributes);
        }
        return edge;
    }

    protected Graph createEmptyGraph() {
        Graph graph = new Graph();
        if (this.layoutAlgorithm != null) {
            ZestProperties.setLayout((Graph)graph, (ILayoutAlgorithm)this.layoutAlgorithm);
        }
        return graph;
    }

    protected Module createModule() {
        if (PlatformUI.isWorkbenchRunning()) {
            return Modules.override((Module[])new Module[]{new ZestFxUiModule()}).with(new Module[]{new ZestFxModule()});
        }
        return new ZestFxModule();
    }

    protected Graph createNestedGraph(Object contentNestingNode, INestedGraphContentProvider nestedGraphContentProvider, ILabelProvider labelProvider) {
        Object[] contentNodes;
        INestedGraphLabelProvider nestedGraphLabelProvider;
        Map<String, Object> nestedGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof INestedGraphLabelProvider && (nestedGraphAttributes = (nestedGraphLabelProvider = (INestedGraphLabelProvider)labelProvider).getNestedGraphAttributes(contentNestingNode)) != null) {
            graph.getAttrs().putAll(nestedGraphAttributes);
        }
        if ((contentNodes = nestedGraphContentProvider.getChildren(contentNestingNode)) != null) {
            this.createNodesAndEdges(nestedGraphContentProvider, labelProvider, graph, contentNodes);
        }
        return graph;
    }

    protected org.eclipse.gef4.graph.Node createNode(Object contentNode, IGraphNodeContentProvider graphContentProvider, ILabelProvider labelProvider) {
        INestedGraphContentProvider nestedGraphProvider;
        IGraphNodeLabelProvider graphNodeLabelProvider;
        Map<String, Object> nodeAttributes;
        IToolTipProvider toolTipProvider;
        String toolTipText;
        org.eclipse.swt.graphics.Image icon;
        if (this.contentNodeMap.containsKey(contentNode)) {
            throw new IllegalStateException("A node for content <" + contentNode + "> has already been created.");
        }
        org.eclipse.gef4.graph.Node node = new org.eclipse.gef4.graph.Node();
        this.contentNodeMap.put(contentNode, node);
        String label = labelProvider.getText(contentNode);
        if (label != null) {
            ZestProperties.setLabel((org.eclipse.gef4.graph.Node)node, (String)label);
        }
        if ((icon = labelProvider.getImage(contentNode)) != null) {
            ZestProperties.setIcon((org.eclipse.gef4.graph.Node)node, (Image)SWTFXUtils.toFXImage((ImageData)icon.getImageData(), null));
        }
        if (labelProvider instanceof IToolTipProvider && (toolTipText = (toolTipProvider = (IToolTipProvider)labelProvider).getToolTipText(contentNode)) != null) {
            ZestProperties.setTooltip((org.eclipse.gef4.graph.Node)node, (String)toolTipText);
        }
        String textCssStyle = "";
        if (labelProvider instanceof IColorProvider) {
            IColorProvider colorProvider = (IColorProvider)labelProvider;
            Color foreground = colorProvider.getForeground(contentNode);
            Color background = colorProvider.getBackground(contentNode);
            String rectCssStyle = "";
            if (background != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-fill: " + this.toCssRgb(background) + ";";
            }
            if (foreground != null) {
                rectCssStyle = String.valueOf(rectCssStyle) + "-fx-stroke: " + this.toCssRgb(foreground) + ";";
                textCssStyle = "-fx-fill: " + this.toCssRgb(foreground) + ";";
            }
            if (!rectCssStyle.isEmpty()) {
                ZestProperties.setNodeRectCssStyle((org.eclipse.gef4.graph.Node)node, (String)rectCssStyle);
            }
        }
        if (labelProvider instanceof IFontProvider) {
            FontData[] fontData;
            IFontProvider fontProvider = (IFontProvider)labelProvider;
            Font font = fontProvider.getFont(contentNode);
            FontData[] fontDataArray = fontData = font == null ? null : font.getFontData();
            if (fontData != null && fontData.length > 0 && fontData[0] != null) {
                String name = fontData[0].getName();
                int size = fontData[0].getHeight();
                int style = fontData[0].getStyle();
                boolean isBold = (style & 1) != 0;
                boolean isItalic = (style & 2) != 0;
                textCssStyle = String.valueOf(textCssStyle) + "-fx-font-family: \"" + name + "\";" + "-fx-font-size: " + size + "pt;";
                if (isItalic) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-style: italic;";
                }
                if (isBold) {
                    textCssStyle = String.valueOf(textCssStyle) + "-fx-font-weight: bold;";
                }
            }
        }
        ZestProperties.setNodeTextCssStyle((org.eclipse.gef4.graph.Node)node, (String)textCssStyle);
        if (labelProvider instanceof IGraphNodeLabelProvider && (nodeAttributes = (graphNodeLabelProvider = (IGraphNodeLabelProvider)labelProvider).getNodeAttributes(contentNode)) != null) {
            node.getAttrs().putAll(nodeAttributes);
        }
        if (graphContentProvider instanceof INestedGraphContentProvider && (nestedGraphProvider = (INestedGraphContentProvider)graphContentProvider).hasChildren(contentNode)) {
            Graph graph = this.createNestedGraph(contentNode, nestedGraphProvider, labelProvider);
            graph.setNestingNode(node);
        }
        return node;
    }

    protected void createNodesAndEdges(IGraphNodeContentProvider graphContentProvider, ILabelProvider labelProvider, Graph graph, Object[] contentNodes) {
        Object[] objectArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object node = objectArray[n2];
            org.eclipse.gef4.graph.Node graphNode = this.createNode(node, graphContentProvider, labelProvider);
            graph.getNodes().add(graphNode);
            graphNode.setGraph(graph);
            ++n2;
        }
        objectArray = contentNodes;
        n = contentNodes.length;
        n2 = 0;
        while (n2 < n) {
            Object contentSourceNode = objectArray[n2];
            org.eclipse.gef4.graph.Node sourceNode = this.contentNodeMap.get(contentSourceNode);
            Object[] connectedTo = graphContentProvider.getConnectedTo(contentSourceNode);
            if (connectedTo != null) {
                Object[] objectArray2 = connectedTo;
                int n3 = connectedTo.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object contentTargetNode = objectArray2[n4];
                    org.eclipse.gef4.graph.Node targetNode = this.contentNodeMap.get(contentTargetNode);
                    Edge edge = this.createEdge(labelProvider, contentSourceNode, sourceNode, contentTargetNode, targetNode);
                    graph.getEdges().add(edge);
                    edge.setGraph(graph);
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected Graph createRootGraph(IContentProvider contentProvider, ILabelProvider labelProvider) {
        IGraphNodeContentProvider graphNodeProvider;
        Object[] nodes;
        IGraphNodeLabelProvider graphNodeLabelProvider;
        Map<String, Object> rootGraphAttributes;
        Graph graph = this.createEmptyGraph();
        if (labelProvider instanceof IGraphNodeLabelProvider && (rootGraphAttributes = (graphNodeLabelProvider = (IGraphNodeLabelProvider)labelProvider).getRootGraphAttributes()) != null) {
            graph.getAttrs().putAll(rootGraphAttributes);
        }
        if (contentProvider instanceof IGraphNodeContentProvider && (nodes = (graphNodeProvider = (IGraphNodeContentProvider)contentProvider).getNodes()) != null) {
            this.createNodesAndEdges(graphNodeProvider, labelProvider, graph, nodes);
        }
        return graph;
    }

    public Map<Object, org.eclipse.gef4.graph.Node> getContentNodeMap() {
        return Collections.unmodifiableMap(this.contentNodeMap);
    }

    public FXCanvas getControl() {
        return this.canvas;
    }

    public FXViewer getFXViewer() {
        return this.viewer;
    }

    public ILabelProvider getLabelProvider() {
        return (ILabelProvider)super.getLabelProvider();
    }

    public ILayoutAlgorithm getLayoutAlgorithm() {
        return this.layoutAlgorithm;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.selectionForwarder != null) {
            this.selectionForwarder.dispose();
            this.selectionForwarder = null;
        }
        this.domain.deactivate();
        this.domain.dispose();
        super.handleDispose(event);
    }

    protected void inputChanged(Object input, Object oldInput) {
        if (!(input == oldInput || input != null && input.equals(oldInput))) {
            this.refresh();
        }
    }

    public void refresh() {
        this.contentNodeMap.clear();
        ((ContentModel)this.viewer.getAdapter(ContentModel.class)).setContents(Collections.singletonList(this.createRootGraph(this.getContentProvider(), this.getLabelProvider())));
    }

    public void setLayoutAlgorithm(ILayoutAlgorithm layoutAlgorithm) {
        this.layoutAlgorithm = layoutAlgorithm;
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (!(this.selection == selection || this.selection != null && this.selection.equals(selection))) {
            StructuredSelection sel;
            this.selection = selection;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            if (reveal && selection instanceof StructuredSelection && !(sel = (StructuredSelection)selection).isEmpty()) {
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object content = objectArray[n2];
                    IContentPart part = (IContentPart)this.viewer.getContentPartMap().get(content);
                    if (part != null) {
                        this.viewer.reveal((IVisualPart)part);
                    }
                    ++n2;
                }
            }
        }
    }

    protected String toCssRgb(Color color) {
        return "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
    }
}

