/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import javafx.scene.Node;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.zest.fx.models.LayoutModel;

public abstract class AbstractLayoutBehavior
extends AbstractBehavior<Node> {
    private Runnable postLayout = new Runnable(){

        @Override
        public void run() {
            AbstractLayoutBehavior.this.postLayout();
        }
    };
    private Runnable preLayout = new Runnable(){

        @Override
        public void run() {
            AbstractLayoutBehavior.this.preLayout();
        }
    };

    public void activate() {
        super.activate();
        LayoutModel layoutModel = this.getLayoutModel();
        layoutModel.schedulePreLayoutPass(this.preLayout);
        layoutModel.schedulePostLayoutPass(this.postLayout);
    }

    public void deactivate() {
        LayoutModel layoutModel = this.getLayoutModel();
        layoutModel.unschedulePreLayoutPass(this.preLayout);
        layoutModel.unschedulePostLayoutPass(this.postLayout);
        super.deactivate();
    }

    protected abstract LayoutModel getLayoutModel();

    protected abstract void postLayout();

    protected abstract void preLayout();
}

