/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.ILayoutFilter;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ViewportModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.layout.GraphEdgeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.models.LayoutModel;
import org.eclipse.gef4.zest.fx.models.ViewportStackModel;
import org.eclipse.gef4.zest.fx.parts.GraphContentPart;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class LayoutContextBehavior
extends AbstractBehavior<Node> {
    private PropertyChangeListener layoutContextPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutContextBehavior.this.onLayoutContextPropertyChange(evt);
        }
    };
    private boolean isHostActive;
    private GraphLayoutContext layoutContext;
    private Pane nestingVisual;
    private PropertyChangeListener viewportModelPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutContextBehavior.this.onViewportModelPropertyChange(evt);
        }
    };
    private ChangeListener<? super Bounds> nestingVisualLayoutBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            LayoutContextBehavior.this.onNestingVisualLayoutBoundsChange(oldLayoutBounds, newLayoutBounds);
        }
    };
    private PropertyChangeListener hostPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LayoutContextBehavior.this.onHostPropertyChange(evt);
        }
    };

    public void activate() {
        super.activate();
        this.getHost().addPropertyChangeListener(this.hostPropertyChangeListener);
        Rectangle initialBounds = new Rectangle();
        if (this.getHost().getParent() == this.getHost().getRoot()) {
            ViewportModel viewportModel = this.getViewportModel();
            viewportModel.addPropertyChangeListener(this.viewportModelPropertyChangeListener);
            FXViewer fxViewer = (FXViewer)this.getHost().getRoot().getViewer();
            double[] scrollableBounds = fxViewer.getScrollPane().computeScrollableBoundsInLocal();
            initialBounds.setX(scrollableBounds[0]);
            initialBounds.setY(scrollableBounds[1]);
            initialBounds.setWidth(fxViewer.getScrollPane().getWidth());
            initialBounds.setHeight(fxViewer.getScrollPane().getHeight());
        } else if (this.getHost().getContent().getNestingNode() != null) {
            this.nestingVisual = this.getNestingPart().getNestedChildrenPane();
            this.nestingVisual.layoutBoundsProperty().addListener(this.nestingVisualLayoutBoundsChangeListener);
            Bounds layoutBounds = this.nestingVisual.getLayoutBounds();
            initialBounds.setWidth(layoutBounds.getWidth());
            initialBounds.setHeight(layoutBounds.getHeight());
        } else {
            throw new IllegalStateException("Graph is neither nested nor root?!");
        }
        this.layoutContext = this.getLayoutModel();
        final HidingModel hidingModel = (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
        this.layoutContext.addLayoutFilter(new ILayoutFilter(){

            public boolean isLayoutIrrelevant(IConnectionLayout connectionLayout) {
                return ZestProperties.getLayoutIrrelevant(((GraphEdgeLayout)connectionLayout).getEdge(), true) != false || this.isLayoutIrrelevant(connectionLayout.getSource()) || this.isLayoutIrrelevant(connectionLayout.getTarget());
            }

            public boolean isLayoutIrrelevant(INodeLayout nodeLayout) {
                org.eclipse.gef4.graph.Node node = (org.eclipse.gef4.graph.Node)nodeLayout.getItems()[0];
                return ZestProperties.getLayoutIrrelevant(node, true) != false || hidingModel.isHidden(node);
            }
        });
        LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)initialBounds);
        this.layoutContext.addPropertyChangeListener(this.layoutContextPropertyChangeListener);
    }

    protected void applyStaticLayout() {
        if (!this.isHostActive) {
            return;
        }
        ViewportStackModel viewportStackModel = (ViewportStackModel)this.getHost().getRoot().getViewer().getAdapter(ViewportStackModel.class);
        if (viewportStackModel.removeSkipNextLayout(this.getHost().getContent())) {
            return;
        }
        this.layoutContext.applyStaticLayout(true);
        this.layoutContext.flushChanges(false);
    }

    public void deactivate() {
        super.deactivate();
        this.getHost().removePropertyChangeListener(this.hostPropertyChangeListener);
        if (this.layoutContext != null) {
            this.layoutContext.removePropertyChangeListener(this.layoutContextPropertyChangeListener);
        }
        if (this.nestingVisual == null) {
            this.getViewportModel().removePropertyChangeListener(this.viewportModelPropertyChangeListener);
        } else {
            this.nestingVisual.layoutBoundsProperty().removeListener(this.nestingVisualLayoutBoundsChangeListener);
        }
        this.layoutContext = null;
        this.nestingVisual = null;
        this.isHostActive = false;
    }

    public GraphContentPart getHost() {
        return (GraphContentPart)super.getHost();
    }

    protected LayoutModel getLayoutModel() {
        return (LayoutModel)((Object)this.getHost().getAdapter(LayoutModel.class));
    }

    protected NodeContentPart getNestingPart() {
        org.eclipse.gef4.graph.Node nestingNode = this.getHost().getContent().getNestingNode();
        IContentPart nestingNodePart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(nestingNode);
        return (NodeContentPart)nestingNodePart;
    }

    protected ViewportModel getViewportModel() {
        return (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
    }

    protected void onHostPropertyChange(PropertyChangeEvent evt) {
        if ("activationComplete".equals(evt.getPropertyName())) {
            if (((Boolean)evt.getNewValue()).booleanValue()) {
                this.isHostActive = true;
                this.applyStaticLayout();
            }
        } else if ("synchronizationComplete".equals(evt.getPropertyName()) && this.isHostActive && ((Boolean)evt.getNewValue()).booleanValue()) {
            this.applyStaticLayout();
        }
    }

    protected void onLayoutContextPropertyChange(PropertyChangeEvent evt) {
        if ("staticLayoutAlgorithm".equals(evt.getPropertyName())) {
            this.applyStaticLayout();
        } else if ("bounds".equals(evt.getPropertyName())) {
            this.applyStaticLayout();
        }
    }

    protected void onNestingVisualLayoutBoundsChange(Bounds oldLayoutBounds, Bounds newLayoutBounds) {
        double width = newLayoutBounds.getWidth();
        double height = newLayoutBounds.getHeight();
        Rectangle newBounds = new Rectangle(0.0, 0.0, width, height);
        if (!LayoutProperties.getBounds((ILayoutContext)this.layoutContext).equals((Object)newBounds)) {
            LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)newBounds);
        }
    }

    protected void onViewportModelPropertyChange(PropertyChangeEvent evt) {
        if (!"viewportWidth".equals(evt.getPropertyName()) && !"viewportHeight".equals(evt.getPropertyName())) {
            return;
        }
        FXViewer fxViewer = (FXViewer)this.getHost().getRoot().getViewer();
        double[] scrollableBounds = fxViewer.getScrollPane().computeScrollableBoundsInLocal();
        Rectangle newBounds = new Rectangle(scrollableBounds[0], scrollableBounds[1], fxViewer.getScrollPane().getWidth(), fxViewer.getScrollPane().getHeight());
        if (!LayoutProperties.getBounds((ILayoutContext)this.layoutContext).equals((Object)newBounds)) {
            LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)newBounds);
        }
    }
}

