/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.fx.policies.FXResizeRelocatePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef4.zest.fx.layout.GraphNodeLayout;
import org.eclipse.gef4.zest.fx.models.LayoutModel;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class NodeLayoutBehavior
extends AbstractLayoutBehavior {
    public static Class<FXResizeRelocatePolicy> RESIZE_RELOCATE_POLICY_KEY = FXResizeRelocatePolicy.class;

    @Override
    public void activate() {
        super.activate();
    }

    public void adaptLayoutInformation() {
        FXResizeRelocatePolicy policy = (FXResizeRelocatePolicy)this.getHost().getAdapter(RESIZE_RELOCATE_POLICY_KEY);
        if (policy != null) {
            Node visual = (Node)this.getHost().getVisual();
            Bounds layoutBounds = visual.getLayoutBounds();
            FXTransformPolicy txPolicy = (FXTransformPolicy)this.getHost().getAdapter(FXTransformPolicy.class);
            Affine transform = txPolicy.getNodeTransform();
            double x = transform.getTx();
            double y = transform.getTy();
            double w = layoutBounds.getWidth();
            double h = layoutBounds.getHeight();
            GraphNodeLayout nodeLayout = this.getNodeLayout();
            Point location = LayoutProperties.getLocation((IEntityLayout)nodeLayout);
            Dimension size = LayoutProperties.getSize((IEntityLayout)nodeLayout);
            double dx = location.x - size.width / 2.0 - x;
            double dy = location.y - size.height / 2.0 - y;
            double dw = size.width - w;
            double dh = size.height - h;
            policy.init();
            policy.performResizeRelocate(dx, dy, dw, dh);
            IUndoableOperation operation = policy.commit();
            if (operation != null) {
                try {
                    operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public NodeContentPart getHost() {
        return (NodeContentPart)super.getHost();
    }

    @Override
    protected LayoutModel getLayoutModel() {
        IContentPart graphPart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(this.getHost().getContent().getGraph());
        return (LayoutModel)((Object)graphPart.getAdapter(LayoutModel.class));
    }

    protected GraphNodeLayout getNodeLayout() {
        GraphNodeLayout nodeLayout = this.getLayoutModel().getNodeLayout(this.getHost().getContent());
        if (nodeLayout == null) {
            throw new IllegalStateException("Cannot find INodeLayout in LayoutModel.");
        }
        return nodeLayout;
    }

    @Override
    protected void postLayout() {
        this.adaptLayoutInformation();
        this.getHost().refreshVisual();
    }

    @Override
    protected void preLayout() {
        this.provideLayoutInformation();
    }

    public void provideLayoutInformation() {
        Node visual = (Node)this.getHost().getVisual();
        Bounds hostBounds = visual.getLayoutBounds();
        double minx = hostBounds.getMinX();
        double miny = hostBounds.getMinY();
        double maxx = hostBounds.getMaxX();
        double maxy = hostBounds.getMaxY();
        for (IVisualPart anchored : this.getHost().getAnchoreds()) {
            if (!(anchored instanceof IFeedbackPart)) continue;
            Node anchoredVisual = (Node)anchored.getVisual();
            Bounds anchoredBounds = anchoredVisual.getLayoutBounds();
            Bounds anchoredBoundsInHost = visual.sceneToLocal(anchoredVisual.localToScene(anchoredBounds));
            minx = Math.min(minx, anchoredBoundsInHost.getMinX());
            miny = Math.min(miny, anchoredBoundsInHost.getMinY());
            maxx = Math.max(maxx, anchoredBoundsInHost.getMaxX());
            maxy = Math.max(maxy, anchoredBoundsInHost.getMaxY());
        }
        FXTransformPolicy txPolicy = (FXTransformPolicy)this.getHost().getAdapter(FXTransformPolicy.class);
        Affine transform = txPolicy.getNodeTransform();
        GraphNodeLayout nodeLayout = this.getNodeLayout();
        LayoutProperties.setLocation((IEntityLayout)nodeLayout, (double)(transform.getTx() + minx), (double)(transform.getTy() + miny));
        LayoutProperties.setSize((IEntityLayout)nodeLayout, (double)(maxx - minx), (double)(maxy - miny));
        LayoutProperties.setResizable((IEntityLayout)nodeLayout, (boolean)visual.isResizable());
    }
}

