/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.models.ViewportModel;
import org.eclipse.gef4.zest.fx.models.ViewportStackModel;
import org.eclipse.gef4.zest.fx.parts.GraphRootPart;

public class OpenParentGraphOnZoomBehavior
extends AbstractBehavior<Node> {
    private PropertyChangeListener viewportPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ContentModel contentModel = (ContentModel)OpenParentGraphOnZoomBehavior.this.getHost().getViewer().getAdapter(ContentModel.class);
            List contents = contentModel.getContents();
            if (contents.size() != 1) {
                return;
            }
            Graph graph = (Graph)contents.get(0);
            if (graph.getNestingNode() == null) {
                return;
            }
            if ("viewportContentsTransform".equals(evt.getPropertyName())) {
                double newScale;
                AffineTransform oldTransform = (AffineTransform)evt.getOldValue();
                AffineTransform newTransform = (AffineTransform)evt.getNewValue();
                double oldScale = oldTransform.getScaleX();
                if (oldScale != (newScale = newTransform.getScaleX())) {
                    OpenParentGraphOnZoomBehavior.this.onZoomLevelChange(oldScale, newScale);
                }
            }
        }
    };

    public void activate() {
        super.activate();
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        viewportModel.addPropertyChangeListener(this.viewportPropertyChangeListener);
    }

    public void deactivate() {
        ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
        viewportModel.removePropertyChangeListener(this.viewportPropertyChangeListener);
        super.deactivate();
    }

    public GraphRootPart getHost() {
        return (GraphRootPart)super.getHost();
    }

    protected void onZoomLevelChange(double oldScale, double newScale) {
        if (oldScale > newScale && newScale < 0.7) {
            ViewportModel viewportModel = (ViewportModel)this.getHost().getRoot().getViewer().getAdapter(ViewportModel.class);
            ViewportStackModel viewportStackModel = (ViewportStackModel)this.getHost().getRoot().getViewer().getAdapter(ViewportStackModel.class);
            viewportStackModel.pop(viewportModel);
            ContentModel contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
            Graph graph = (Graph)contentModel.getContents().get(0);
            viewportStackModel.addSkipNextLayout(graph);
            contentModel.setContents(Collections.singletonList(graph.getNestingNode().getGraph()));
        }
    }
}

