/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.gef4.common.properties.IPropertyStore;
import org.eclipse.gef4.common.properties.PropertyStoreSupport;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;

public class GraphNodeLayout
implements INodeLayout {
    private GraphLayoutContext context;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyStoreSupport pss = new PropertyStoreSupport((IPropertyStore)this, this.pcs);
    private Node node;
    private ISubgraphLayout subgraph;

    public GraphNodeLayout(GraphLayoutContext context, Node node) {
        this.context = context;
        this.node = node;
        for (Map.Entry e : node.getAttrs().entrySet()) {
            this.setProperty((String)e.getKey(), e.getValue());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public IConnectionLayout[] getIncomingConnections() {
        IConnectionLayout[] connections;
        ArrayList<IConnectionLayout> incoming = new ArrayList<IConnectionLayout>();
        IConnectionLayout[] iConnectionLayoutArray = connections = this.context.getConnections();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionLayout c = iConnectionLayoutArray[n2];
            if (c.getTarget() == this) {
                incoming.add(c);
            }
            ++n2;
        }
        return incoming.toArray(new IConnectionLayout[0]);
    }

    public Object[] getItems() {
        return new Object[]{this.node};
    }

    public IConnectionLayout[] getOutgoingConnections() {
        IConnectionLayout[] connections;
        ArrayList<IConnectionLayout> outgoing = new ArrayList<IConnectionLayout>();
        IConnectionLayout[] iConnectionLayoutArray = connections = this.context.getConnections();
        int n = connections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionLayout c = iConnectionLayoutArray[n2];
            if (c.getSource() == this) {
                outgoing.add(c);
            }
            ++n2;
        }
        return outgoing.toArray(new IConnectionLayout[0]);
    }

    public IEntityLayout[] getPredecessingEntities() {
        return this.getPredecessingNodes();
    }

    public INodeLayout[] getPredecessingNodes() {
        IConnectionLayout[] incomingConnections = this.getIncomingConnections();
        INodeLayout[] predecessors = new INodeLayout[incomingConnections.length];
        int i = 0;
        IConnectionLayout[] iConnectionLayoutArray = incomingConnections;
        int n = incomingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionLayout incomingConnection = iConnectionLayoutArray[n2];
            predecessors[i++] = incomingConnection.getSource();
            ++n2;
        }
        return predecessors;
    }

    public Object getProperty(String name) {
        return this.pss.getProperty(name);
    }

    public ISubgraphLayout getSubgraph() {
        return this.subgraph;
    }

    public IEntityLayout[] getSuccessingEntities() {
        return this.getSuccessingNodes();
    }

    public INodeLayout[] getSuccessingNodes() {
        IConnectionLayout[] outgoingConnections = this.getOutgoingConnections();
        INodeLayout[] successors = new INodeLayout[outgoingConnections.length];
        int i = 0;
        IConnectionLayout[] iConnectionLayoutArray = outgoingConnections;
        int n = outgoingConnections.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionLayout outgoingConnection = iConnectionLayoutArray[n2];
            successors[i++] = outgoingConnection.getTarget();
            ++n2;
        }
        return successors;
    }

    public void prune(ISubgraphLayout subgraph) {
        if (this.subgraph != null) {
            this.subgraph.removeNodes(new INodeLayout[]{this});
        }
        this.subgraph = subgraph;
        subgraph.addNodes(new INodeLayout[]{this});
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object value) {
        Object oldValue = this.pss.getProperty(name);
        if ("location".equals(name) && value instanceof Point) {
            Point p = (Point)value;
            if (Double.isNaN(p.x)) {
                p.x = 0.0;
            }
            if (Double.isNaN(p.y)) {
                p.y = 0.0;
            }
        }
        this.pss.setProperty(name, value);
        if (!(value == oldValue || value != null && value.equals(oldValue))) {
            if ("location".equals(name)) {
                this.context.fireNodeMovedEvent(this);
            } else if ("size".equals(name)) {
                this.context.fireNodeResizedEvent(this);
            }
        }
    }
}

