/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.fx.nodes.FXConnection;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.parts.AbstractVisualPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.parts.EdgeContentPart;

public class EdgeLabelPart
extends AbstractVisualPart<Node, Text> {
    private VisualChangeListener vcl = new VisualChangeListener(){

        protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
            EdgeLabelPart.this.refreshVisual();
        }

        protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
            EdgeLabelPart.this.refreshVisual();
        }
    };
    private Translate translate;

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        this.vcl.register((Node)anchorage.getVisual(), (Node)this.getVisual());
    }

    protected Text createVisual() {
        Text text = new Text();
        text.setTextOrigin(VPos.TOP);
        text.setManaged(false);
        text.setPickOnBounds(true);
        this.translate = new Translate();
        text.getTransforms().add((Object)this.translate);
        return text;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        this.vcl.unregister();
    }

    protected void doRefreshVisual(Text visual) {
        EdgeContentPart edgeContentPart = this.getHost();
        if (edgeContentPart == null) {
            return;
        }
        Rectangle bounds = ((ICurve)((FXConnection)edgeContentPart.getVisual()).getCurveNode().getGeometry()).getBounds();
        Bounds textBounds = ((Text)this.getVisual()).getLayoutBounds();
        visual.setTranslateX(bounds.getX() + bounds.getWidth() / 2.0 - textBounds.getWidth() / 2.0);
        visual.setTranslateY(bounds.getY() + bounds.getHeight() / 2.0 - textBounds.getHeight());
    }

    public EdgeContentPart getHost() {
        return this.getAnchorages().isEmpty() ? null : (EdgeContentPart)((Object)this.getAnchorages().keys().iterator().next());
    }

    public Translate getOffset() {
        return this.translate;
    }
}

