/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXOnHoverPolicy;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SynchronizeContentAnchoragesOperation;
import org.eclipse.gef4.mvc.operations.SynchronizeContentChildrenOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.models.LayoutModel;

public class GraphContentPart
extends AbstractFXContentPart<Group> {
    public static final String ACTIVATION_COMPLETE_PROPERTY = "activationComplete";
    public static final String SYNC_COMPLETE_PROPERTY = "synchronizationComplete";
    private PropertyChangeListener graphPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("attributes".equals(evt.getPropertyName())) {
                GraphContentPart.this.refreshVisual();
            } else if ("nodes".equals(evt.getPropertyName()) || "edges".equals(evt.getPropertyName())) {
                ((LayoutModel)((Object)GraphContentPart.this.getAdapter(LayoutModel.class))).setGraph(GraphContentPart.this.getContent());
                SynchronizeContentChildrenOperation syncChildrenOp = new SynchronizeContentChildrenOperation("SynchronizeContentChildren", (IContentPart)GraphContentPart.this);
                SynchronizeContentAnchoragesOperation syncAnchoragesOp = new SynchronizeContentAnchoragesOperation("SynchronizeContentAnchorage", (IContentPart)GraphContentPart.this);
                ForwardUndoCompositeOperation syncOp = new ForwardUndoCompositeOperation("SynchronizeContent");
                syncOp.add((IUndoableOperation)syncChildrenOp);
                syncOp.add((IUndoableOperation)syncAnchoragesOp);
                try {
                    syncOp.execute(null, null);
                    GraphContentPart.this.pcs.firePropertyChange(GraphContentPart.SYNC_COMPLETE_PROPERTY, false, true);
                }
                catch (ExecutionException e) {
                    throw new IllegalStateException("Cannot synchronize with contents.", e);
                }
            }
        }
    };

    public GraphContentPart() {
        this.setAdapter(AdapterKey.get(AbstractFXOnHoverPolicy.class), new AbstractFXOnHoverPolicy(){

            public void hover(MouseEvent e) {
            }
        });
    }

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    protected Group createVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        return visual;
    }

    protected void doActivate() {
        super.doActivate();
        this.getContent().addPropertyChangeListener(this.graphPropertyChangeListener);
        this.pcs.firePropertyChange(ACTIVATION_COMPLETE_PROPERTY, false, true);
        this.refreshVisual();
    }

    protected void doDeactivate() {
        this.getContent().removePropertyChangeListener(this.graphPropertyChangeListener);
        super.doDeactivate();
    }

    public void doRefreshVisual(Group visual) {
        this.setGraphLayoutAlgorithm();
    }

    public Graph getContent() {
        return (Graph)super.getContent();
    }

    public List<Object> getContentChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(this.getContent().getEdges());
        children.addAll(this.getContent().getNodes());
        return children;
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().remove(child.getVisual());
    }

    public void setContent(Object content) {
        super.setContent(content);
        ((LayoutModel)((Object)this.getAdapter(LayoutModel.class))).setGraph(this.getContent());
    }

    private void setGraphLayoutAlgorithm() {
        Object algo = this.getContent().getAttrs().get("layout");
        if (algo instanceof ILayoutAlgorithm) {
            ILayoutAlgorithm layoutAlgorithm = (ILayoutAlgorithm)algo;
            ILayoutContext layoutContext = (ILayoutContext)this.getAdapter(LayoutModel.class);
            if (layoutContext != null && layoutContext.getStaticLayoutAlgorithm() != algo) {
                layoutContext.setStaticLayoutAlgorithm(layoutAlgorithm);
            }
        }
    }
}

