/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt;

import com.google.common.reflect.TypeToken;

public class AdapterKey<T> {
    public static final String DEFAULT_ROLE = "default";
    private TypeToken<T> key;
    private String role;

    private AdapterKey(TypeToken<T> typeKey, String role) {
        this.key = typeKey;
        this.role = role;
    }

    public TypeToken<T> getKey() {
        return this.key;
    }

    public String getRole() {
        return this.role;
    }

    public static <T> AdapterKey<T> get(Class<T> key, String role) {
        if (key == null) {
            throw new NullPointerException("Key may not be null.");
        }
        if (role == null) {
            throw new NullPointerException("Role may not be null.");
        }
        return new AdapterKey<T>(TypeToken.of(key), role);
    }

    public static <T> AdapterKey<T> get(TypeToken<T> key, String role) {
        if (key == null) {
            throw new NullPointerException("Key may not be null.");
        }
        if (role == null) {
            throw new NullPointerException("Role may not be null.");
        }
        return new AdapterKey<T>(key, role);
    }

    public static <T> AdapterKey<T> get(Class<T> key) {
        return AdapterKey.get(TypeToken.of(key), DEFAULT_ROLE);
    }

    public static <T> AdapterKey<T> get(TypeToken<T> key) {
        return AdapterKey.get(key, DEFAULT_ROLE);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdapterKey other = (AdapterKey)obj;
        return this.key.equals(other.getKey()) && this.role.equals(other.role);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public String toString() {
        return "AdapterKey(" + this.key + ", " + this.role + ")";
    }
}

