/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.notify;

import com.google.common.collect.ForwardingMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef4.common.notify.IMapObserver;

public class ObservableMap<K, V>
extends ForwardingMap<K, V> {
    private List<IMapObserver<K, V>> observers = new ArrayList<IMapObserver<K, V>>();
    private Map<K, V> backingMap = new HashMap();

    public void addMapObserver(IMapObserver<K, V> mapObserver) {
        this.observers.add(mapObserver);
    }

    public void clear() {
        if (!this.isEmpty()) {
            Map<K, V> old = this.getBackingMapCopy();
            super.clear();
            this.notifyChanged(old);
        }
    }

    protected Map<K, V> delegate() {
        return this.backingMap;
    }

    protected Map<K, V> getBackingMapCopy() {
        return new HashMap<K, V>(this.backingMap);
    }

    protected void notifyChanged(Map<K, V> old) {
        for (IMapObserver<K, V> observer : this.observers) {
            observer.afterChange(this, old);
        }
    }

    public V put(K key, V value) {
        Object previousValue = this.get(key);
        if (value != previousValue) {
            Map<K, V> old = this.getBackingMapCopy();
            super.put(key, value);
            this.notifyChanged(old);
            return (V)previousValue;
        }
        return (V)previousValue;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        Map<K, V> old = this.getBackingMapCopy();
        super.putAll(map);
        if (!this.equals(old)) {
            this.notifyChanged(old);
        }
    }

    public V remove(Object key) {
        if (this.containsKey(key)) {
            Map<K, V> old = this.getBackingMapCopy();
            Object previousValue = super.remove(key);
            this.notifyChanged(old);
            return (V)previousValue;
        }
        return null;
    }

    public void removeMapObserver(IMapObserver<K, V> mapObserver) {
        this.observers.remove(mapObserver);
    }
}

