/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.geometry.planar.Point;

public abstract class AbstractFXAnchor
implements IFXAnchor {
    private ReadOnlyObjectWrapper<Node> anchorageProperty = new ReadOnlyObjectWrapper();
    private ReadOnlyMapWrapper<AnchorKey, Point> positionProperty = new ReadOnlyMapWrapper(FXCollections.observableHashMap());
    private Map<Node, Set<AnchorKey>> keys = new HashMap<Node, Set<AnchorKey>>();
    private Map<Node, VisualChangeListener> vcls = new HashMap<Node, VisualChangeListener>();
    private Set<Node> registerLater = new HashSet<Node>();
    private ChangeListener<Scene> anchorageVisualSceneChangeListener = new ChangeListener<Scene>(){

        public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
            if (oldValue != null) {
                AbstractFXAnchor.this.unregisterVCLs();
            }
            if (newValue != null) {
                AbstractFXAnchor.this.registerVCLs();
            }
        }
    };
    private ChangeListener<Node> anchorageChangeListener = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> observable, Node oldAnchorage, Node newAnchorage) {
            if (oldAnchorage != null) {
                AbstractFXAnchor.this.unregisterVCLs();
                oldAnchorage.sceneProperty().removeListener(AbstractFXAnchor.this.anchorageVisualSceneChangeListener);
            }
            if (newAnchorage != null) {
                newAnchorage.sceneProperty().addListener(AbstractFXAnchor.this.anchorageVisualSceneChangeListener);
                Scene scene = newAnchorage.getScene();
                if (scene != null) {
                    AbstractFXAnchor.this.registerVCLs();
                }
            }
        }
    };

    public AbstractFXAnchor(Node anchorage) {
        this.anchorageProperty.addListener(this.anchorageChangeListener);
        this.setAnchorage(anchorage);
    }

    @Override
    public ReadOnlyObjectProperty<Node> anchorageProperty() {
        return this.anchorageProperty.getReadOnlyProperty();
    }

    @Override
    public void attach(AnchorKey key, IAdaptable info) {
        Node anchored = key.getAnchored();
        if (!this.keys.containsKey(anchored)) {
            this.keys.put(anchored, new HashSet());
        }
        this.keys.get(anchored).add(key);
        if (!this.vcls.containsKey(anchored)) {
            VisualChangeListener vcl = this.createVCL(anchored);
            this.vcls.put(anchored, vcl);
            if (this.canRegister(anchored)) {
                vcl.register((Node)this.anchorageProperty.get(), anchored);
            } else {
                this.registerLater(anchored);
            }
        }
        this.updatePosition(key);
    }

    private boolean canRegister(Node anchored) {
        return this.getAnchorage() != null && this.getAnchorage().getScene() != null && anchored != null && anchored.getScene() != null;
    }

    protected abstract Point computePosition(AnchorKey var1);

    private VisualChangeListener createVCL(final Node anchored) {
        return new VisualChangeListener(){

            @Override
            protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
                AbstractFXAnchor.this.updatePositions(anchored);
            }

            @Override
            protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
                AbstractFXAnchor.this.updatePositions(anchored);
            }

            @Override
            public void register(Node observed, Node observer) {
                super.register(observed, observer);
                AbstractFXAnchor.this.updatePositions(anchored);
            }
        };
    }

    @Override
    public void detach(AnchorKey key, IAdaptable info) {
        Node anchored = key.getAnchored();
        if (!this.isAttached(key)) {
            throw new IllegalArgumentException("The given AnchorKey was not previously attached to this IFXAnchor.");
        }
        this.positionProperty.remove((Object)key);
        this.keys.get(anchored).remove(key);
        if (this.keys.get(anchored).isEmpty()) {
            this.keys.remove(anchored);
            VisualChangeListener vcl = this.vcls.remove(anchored);
            if (vcl.isRegistered()) {
                vcl.unregister();
            }
        }
    }

    @Override
    public Node getAnchorage() {
        return (Node)this.anchorageProperty.get();
    }

    protected Map<Node, Set<AnchorKey>> getKeys() {
        return this.keys;
    }

    @Override
    public Point getPosition(AnchorKey key) {
        Node anchored = key.getAnchored();
        if (!this.keys.containsKey(anchored) || !this.keys.get(anchored).contains(key)) {
            throw new IllegalArgumentException("The AnchorKey is not attached to this anchor.");
        }
        if (!this.positionProperty.containsKey((Object)key)) {
            return null;
        }
        return (Point)this.positionProperty.get((Object)key);
    }

    @Override
    public boolean isAttached(AnchorKey key) {
        return this.keys.containsKey(key.getAnchored()) && this.keys.get(key.getAnchored()).contains(key);
    }

    @Override
    public ReadOnlyMapProperty<AnchorKey, Point> positionProperty() {
        return this.positionProperty.getReadOnlyProperty();
    }

    private void registerLater(final Node anchored) {
        if (this.registerLater.contains(anchored)) {
            return;
        }
        this.registerLater.add(anchored);
        ChangeListener<Scene> changeListener = new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> observed, Scene oldScene, Scene newScene) {
                if (AbstractFXAnchor.this.getAnchorage() == null || AbstractFXAnchor.this.getAnchorage().getScene() == null) {
                    return;
                }
                VisualChangeListener vcl = (VisualChangeListener)AbstractFXAnchor.this.vcls.get(anchored);
                if (vcl == null) {
                    return;
                }
                if (oldScene != null && vcl.isRegistered()) {
                    AbstractFXAnchor.this.registerLater.remove(anchored);
                    vcl.unregister();
                }
                if (newScene != null && !vcl.isRegistered()) {
                    vcl.register(AbstractFXAnchor.this.getAnchorage(), anchored);
                    observed.removeListener((ChangeListener)this);
                }
            }
        };
        anchored.sceneProperty().addListener((ChangeListener)changeListener);
    }

    protected void registerVCLs() {
        Node[] nodeArray = this.vcls.keySet().toArray(new Node[0]);
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node anchored = nodeArray[n2];
            if (this.canRegister(anchored)) {
                this.vcls.get(anchored).register(this.getAnchorage(), anchored);
            } else {
                this.registerLater(anchored);
            }
            ++n2;
        }
    }

    protected void setAnchorage(Node anchorage) {
        this.anchorageProperty.set((Object)anchorage);
    }

    protected void unregisterVCLs() {
        Node[] nodeArray = this.vcls.keySet().toArray(new Node[0]);
        int n = nodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Node anchored = nodeArray[n2];
            this.vcls.get(anchored).unregister();
            ++n2;
        }
    }

    protected void updatePosition(AnchorKey key) {
        Point oldPosition = this.getPosition(key);
        Point newPosition = this.computePosition(key);
        if (!(oldPosition != null && oldPosition.equals((Object)newPosition) || newPosition == null || Double.isNaN(newPosition.x) || Double.isNaN(newPosition.y))) {
            this.positionProperty().put((Object)key, (Object)newPosition);
        }
    }

    private void updatePositions(Node anchored) {
        if (this.getKeys().containsKey(anchored)) {
            for (AnchorKey key : this.getKeys().get(anchored)) {
                this.updatePosition(key);
            }
        }
    }
}

