/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.gestures;

import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.gestures.AbstractFXGesture;

public abstract class AbstractFXMouseDragGesture
extends AbstractFXGesture {
    private Node pressed;
    private Point2D startMousePosition;
    private EventHandler<? super MouseEvent> pressedHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            AbstractFXMouseDragGesture.this.onMousePress(event);
        }
    };
    private EventHandler<? super MouseEvent> mouseFilter = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            AbstractFXMouseDragGesture.this.onMouseEvent(event);
        }
    };

    protected abstract void drag(Node var1, MouseEvent var2, double var3, double var5);

    public Node getPressed() {
        return this.pressed;
    }

    protected void onMouseEvent(MouseEvent event) {
        if (this.pressed == null) {
            return;
        }
        EventType type = event.getEventType();
        if (type.equals(MouseEvent.MOUSE_EXITED_TARGET)) {
            return;
        }
        boolean dragged = type.equals(MouseEvent.MOUSE_DRAGGED);
        boolean released = false;
        if (!(dragged || (released = type.equals(MouseEvent.MOUSE_RELEASED)) || event.isPrimaryButtonDown() || event.isSecondaryButtonDown() || event.isMiddleButtonDown())) {
            released = true;
        }
        if (dragged || released) {
            double x = event.getSceneX();
            double dx = x - this.startMousePosition.getX();
            double y = event.getSceneY();
            double dy = y - this.startMousePosition.getY();
            if (dragged) {
                this.drag(this.pressed, event, dx, dy);
            } else {
                this.release(this.pressed, event, dx, dy);
                this.pressed.removeEventHandler(MouseEvent.ANY, this.mouseFilter);
                this.pressed = null;
            }
        }
    }

    protected void onMousePress(MouseEvent event) {
        EventTarget target = event.getTarget();
        if (target instanceof Node) {
            this.pressed = (Node)target;
            this.pressed.addEventHandler(MouseEvent.ANY, this.mouseFilter);
            this.startMousePosition = new Point2D(event.getSceneX(), event.getSceneY());
            this.press(this.pressed, event);
        }
    }

    protected abstract void press(Node var1, MouseEvent var2);

    @Override
    protected void register() {
        this.getScene().addEventFilter(MouseEvent.ANY, this.mouseFilter);
        this.getScene().addEventHandler(MouseEvent.MOUSE_PRESSED, this.pressedHandler);
    }

    protected abstract void release(Node var1, MouseEvent var2, double var3, double var5);

    @Override
    protected void unregister() {
        this.getScene().removeEventHandler(MouseEvent.MOUSE_PRESSED, this.pressedHandler);
        this.getScene().removeEventFilter(MouseEvent.ANY, this.mouseFilter);
    }
}

