/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Rotate;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.AdapterStore;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.FXChopBoxAnchor;
import org.eclipse.gef4.fx.anchors.FXStaticAnchor;
import org.eclipse.gef4.fx.anchors.IFXAnchor;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.fx.nodes.FXPolylineConnectionRouter;
import org.eclipse.gef4.fx.nodes.IFXConnectionRouter;
import org.eclipse.gef4.fx.nodes.IFXDecoration;
import org.eclipse.gef4.geometry.convert.fx.Geometry2JavaFX;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;

public class FXConnection
extends Group {
    public static final String CSS_CLASS_DECORATION = "decoration";
    private static final String START_ROLE = "start";
    private static final String END_ROLE = "end";
    private static final String WAY_POINT_ROLE_PREFIX = "waypoint-";
    private FXGeometryNode<ICurve> curveNode = new FXGeometryNode();
    private IFXConnectionRouter router = new FXPolylineConnectionRouter();
    private AdapterStore as = new AdapterStore();
    private IFXDecoration startDecoration = null;
    private IFXDecoration endDecoration = null;
    private ReadOnlyMapWrapper<AnchorKey, IFXAnchor> anchorsProperty = new ReadOnlyMapWrapper(FXCollections.observableHashMap());
    private List<AnchorKey> wayAnchorKeys = new ArrayList<AnchorKey>();
    private int nextWayAnchorId = 0;
    private boolean inRefresh = false;
    private Map<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>> anchorKeyPCL = new HashMap<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>>();

    public FXConnection() {
        this.setAutoSizeChildren(false);
        this.registerAnchorInfos((IAdaptable)this.as);
    }

    public void addWayAnchor(int index, IFXAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.generateWayAnchorKey();
        this.putAnchor(anchor, anchorKey, index);
    }

    public void addWayPoint(int index, Point wayPointInLocal) {
        if (wayPointInLocal == null) {
            wayPointInLocal = new Point();
        }
        FXStaticAnchor anchor = new FXStaticAnchor((Node)this, wayPointInLocal);
        this.addWayAnchor(index, anchor);
    }

    protected ReadOnlyMapProperty<AnchorKey, IFXAnchor> anchorsProperty() {
        return this.anchorsProperty.getReadOnlyProperty();
    }

    protected Point arrangeDecoration(IFXDecoration decoration, Point start, Vector direction, Point decoStart, Vector decoDirection) {
        Node visual = decoration.getVisual();
        visual.setLayoutX(start.x);
        visual.setLayoutY(start.y);
        Angle angleCW = null;
        if (!direction.isNull() && !decoDirection.isNull()) {
            angleCW = decoDirection.getAngleCW(direction);
            visual.getTransforms().clear();
            visual.getTransforms().add((Object)new Rotate(angleCW.deg(), 0.0, 0.0));
        }
        return angleCW == null ? start : start.getTranslated(decoDirection.getRotatedCW(angleCW).toPoint());
    }

    protected void arrangeEndDecoration() {
        if (this.endDecoration == null) {
            return;
        }
        Point endPoint = this.getEndPoint();
        ICurve curve = this.getCurveNode().getGeometry();
        if (curve == null || endPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve endDerivative = beziers[beziers.length - 1].getDerivative();
        Point slope = endDerivative.get(1.0);
        if (slope.equals(0.0, 0.0)) {
            slope = endDerivative.get(0.99);
        }
        Vector endDirection = new Vector(slope.getNegated());
        Point decoStartPoint = this.endDecoration.getLocalStartPoint();
        Point decoEndPoint = this.endDecoration.getLocalEndPoint();
        Vector decoDirection = new Vector(decoStartPoint, decoEndPoint);
        this.arrangeDecoration(this.endDecoration, endPoint, endDirection, decoStartPoint, decoDirection);
    }

    protected void arrangeStartDecoration() {
        if (this.startDecoration == null) {
            return;
        }
        Point startPoint = this.getStartPoint();
        ICurve curve = this.getCurveNode().getGeometry();
        if (curve == null || startPoint == null) {
            return;
        }
        BezierCurve[] beziers = curve.toBezier();
        if (beziers.length == 0) {
            return;
        }
        BezierCurve startDerivative = beziers[0].getDerivative();
        Point slope = startDerivative.get(0.0);
        if (slope.equals(0.0, 0.0)) {
            slope = startDerivative.get(0.01);
        }
        Vector curveStartDirection = new Vector(slope);
        Point decoStartPoint = this.startDecoration.getLocalStartPoint();
        Point decoEndPoint = this.startDecoration.getLocalEndPoint();
        Vector decoDirection = new Vector(decoStartPoint, decoEndPoint);
        this.arrangeDecoration(this.startDecoration, startPoint, curveStartDirection, decoStartPoint, decoDirection);
    }

    protected MapChangeListener<? super AnchorKey, ? super Point> createPCL(final AnchorKey anchorKey) {
        return new MapChangeListener<AnchorKey, Point>(){

            public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
                if (((AnchorKey)change.getKey()).equals(anchorKey)) {
                    FXConnection.this.refreshGeometry();
                }
            }
        };
    }

    protected AnchorKey generateWayAnchorKey() {
        if (this.nextWayAnchorId == Integer.MAX_VALUE) {
            List<IFXAnchor> wayAnchors = this.getWayAnchors();
            this.removeAllWayPoints();
            this.nextWayAnchorId = 0;
            this.setWayAnchors(wayAnchors);
        }
        return new AnchorKey((Node)this.getCurveNode(), WAY_POINT_ROLE_PREFIX + this.nextWayAnchorId++);
    }

    protected int getAnchorIndex(AnchorKey anchorKey) {
        if (anchorKey.equals(this.getStartAnchorKey())) {
            return 0;
        }
        if (anchorKey.equals(this.getEndAnchorKey())) {
            return this.getAnchors().size() - 1;
        }
        return this.getWayIndex(anchorKey) + 1;
    }

    protected AnchorKey getAnchorKey(int anchorIndex) {
        if (anchorIndex < 0 || anchorIndex >= this.getAnchors().size()) {
            throw new IllegalArgumentException("The given anchor index is out of bounds.");
        }
        if (anchorIndex == 0) {
            return this.getStartAnchorKey();
        }
        if (anchorIndex == this.getAnchors().size() - 1) {
            return this.getEndAnchorKey();
        }
        return this.getWayAnchorKey(anchorIndex - 1);
    }

    public List<IFXAnchor> getAnchors() {
        int wayPointCount = this.getWayAnchorsSize();
        ArrayList<IFXAnchor> anchors = new ArrayList<IFXAnchor>(wayPointCount + 2);
        IFXAnchor startAnchor = this.getStartAnchor();
        if (startAnchor == null) {
            throw new IllegalStateException("Start anchor may never be null.");
        }
        anchors.add(startAnchor);
        anchors.addAll(this.getWayAnchors());
        IFXAnchor endAnchor = this.getEndAnchor();
        if (endAnchor == null) {
            throw new IllegalStateException("End anchor may never be null.");
        }
        anchors.add(endAnchor);
        return anchors;
    }

    public FXGeometryNode<ICurve> getCurveNode() {
        return this.curveNode;
    }

    public IFXAnchor getEndAnchor() {
        return (IFXAnchor)this.anchorsProperty.get((Object)this.getEndAnchorKey());
    }

    protected AnchorKey getEndAnchorKey() {
        return new AnchorKey((Node)this.getCurveNode(), END_ROLE);
    }

    public IFXDecoration getEndDecoration() {
        return this.endDecoration;
    }

    public Point getEndPoint() {
        IFXAnchor anchor = this.getEndAnchor();
        if (anchor == null) {
            return null;
        }
        if (!anchor.isAttached(this.getEndAnchorKey())) {
            return null;
        }
        return JavaFX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2JavaFX.toFXPoint((Point)anchor.getPosition(this.getEndAnchorKey()))));
    }

    public Point[] getPoints() {
        int wayPointCount = this.getWayAnchorsSize();
        Point[] points = new Point[wayPointCount + 2];
        points[0] = this.getStartPoint();
        if (points[0] == null) {
            return new Point[0];
        }
        int i = 0;
        while (i < wayPointCount) {
            points[i + 1] = this.getWayPoint(i);
            if (points[i + 1] == null) {
                return new Point[0];
            }
            ++i;
        }
        points[points.length - 1] = this.getEndPoint();
        if (points[points.length - 1] == null) {
            return new Point[0];
        }
        return points;
    }

    public IFXConnectionRouter getRouter() {
        return this.router;
    }

    public IFXAnchor getStartAnchor() {
        return (IFXAnchor)this.anchorsProperty.get((Object)this.getStartAnchorKey());
    }

    protected AnchorKey getStartAnchorKey() {
        return new AnchorKey((Node)this.getCurveNode(), START_ROLE);
    }

    public IFXDecoration getStartDecoration() {
        return this.startDecoration;
    }

    public Point getStartPoint() {
        IFXAnchor anchor = this.getStartAnchor();
        if (anchor == null) {
            return null;
        }
        if (!anchor.isAttached(this.getStartAnchorKey())) {
            return null;
        }
        return JavaFX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2JavaFX.toFXPoint((Point)anchor.getPosition(this.getStartAnchorKey()))));
    }

    public IFXAnchor getWayAnchor(int index) {
        return (IFXAnchor)this.anchorsProperty.get((Object)this.getWayAnchorKey(index));
    }

    protected AnchorKey getWayAnchorKey(int index) {
        if (index >= 0 && index < this.wayAnchorKeys.size()) {
            return this.wayAnchorKeys.get(index);
        }
        return null;
    }

    public List<IFXAnchor> getWayAnchors() {
        int wayPointsCount = this.getWayAnchorsSize();
        ArrayList<IFXAnchor> wayPointAnchors = new ArrayList<IFXAnchor>(wayPointsCount);
        int i = 0;
        while (i < wayPointsCount) {
            IFXAnchor wayAnchor = this.getWayAnchor(i);
            if (wayAnchor == null) {
                throw new IllegalStateException("Way anchor may never be null.");
            }
            wayPointAnchors.add(wayAnchor);
            ++i;
        }
        return wayPointAnchors;
    }

    public int getWayAnchorsSize() {
        return this.wayAnchorKeys.size();
    }

    protected int getWayIndex(AnchorKey key) {
        int index = this.wayAnchorKeys.indexOf(key);
        if (index == -1) {
            throw new IllegalArgumentException("The given AnchorKey (" + key + ") is not registered as a way point anchor for this connection.");
        }
        return index;
    }

    public Point getWayPoint(int index) {
        IFXAnchor anchor = this.getWayAnchor(index);
        if (anchor == null) {
            throw new IllegalArgumentException("No waypoint at index " + index);
        }
        if (!anchor.isAttached(this.getWayAnchorKey(index))) {
            return null;
        }
        return JavaFX2Geometry.toPoint((Point2D)this.getCurveNode().localToParent(Geometry2JavaFX.toFXPoint((Point)anchor.getPosition(this.getWayAnchorKey(index)))));
    }

    public List<Point> getWayPoints() {
        List<IFXAnchor> wayPointAnchors = this.getWayAnchors();
        ArrayList<Point> wayPoints = new ArrayList<Point>(wayPointAnchors.size());
        int i = 0;
        while (i < wayPointAnchors.size()) {
            wayPoints.add(wayPointAnchors.get(i).getPosition(this.getWayAnchorKey(i)));
            ++i;
        }
        return wayPoints;
    }

    public boolean isEndConnected() {
        IFXAnchor anchor = this.getEndAnchor();
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    public boolean isStartConnected() {
        IFXAnchor anchor = this.getStartAnchor();
        return anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    public boolean isWayConnected(int index) {
        IFXAnchor anchor = this.getWayAnchor(index);
        return anchor.getAnchorage() != null && anchor.getAnchorage() != this;
    }

    protected void putAnchor(IFXAnchor anchor, AnchorKey anchorKey, int wayIndex) {
        if (!anchorKey.equals(this.getStartAnchorKey()) && !anchorKey.equals(this.getEndAnchorKey())) {
            this.wayAnchorKeys.add(wayIndex, anchorKey);
        }
        this.anchorsProperty.put((Object)anchorKey, (Object)anchor);
        anchor.attach(anchorKey, (IAdaptable)this.as);
        if (!this.anchorKeyPCL.containsKey(anchorKey)) {
            MapChangeListener<? super AnchorKey, ? super Point> pcl = this.createPCL(anchorKey);
            this.anchorKeyPCL.put(anchorKey, pcl);
            anchor.positionProperty().addListener(pcl);
        }
        this.refreshGeometry();
    }

    protected void refreshGeometry() {
        if (this.inRefresh) {
            return;
        }
        ICurve newGeometry = this.router.routeConnection(this.getPoints());
        if (this.curveNode != null && this.curveNode.getGeometry() != null && this.curveNode.getGeometry().equals(newGeometry)) {
            return;
        }
        this.inRefresh = true;
        this.getChildren().clear();
        this.curveNode.setGeometry(newGeometry);
        this.getChildren().add(this.curveNode);
        if (this.startDecoration != null) {
            this.getChildren().add((Object)this.startDecoration.getVisual());
            this.arrangeStartDecoration();
        }
        if (this.endDecoration != null) {
            this.getChildren().add((Object)this.endDecoration.getVisual());
            this.arrangeEndDecoration();
        }
        this.inRefresh = false;
    }

    protected void registerAnchorInfos(IAdaptable adaptable) {
        adaptable.setAdapter(AdapterKey.get(FXChopBoxAnchor.ReferencePointProvider.class), (Object)new FXChopBoxHelper(this));
    }

    public void removeAllWayPoints() {
        int i = this.getWayAnchorsSize() - 1;
        while (i >= 0) {
            this.removeWayPoint(i);
            --i;
        }
    }

    protected void removeAnchor(AnchorKey anchorKey, IFXAnchor oldAnchor) {
        if (this.anchorKeyPCL.containsKey(anchorKey)) {
            oldAnchor.positionProperty().removeListener(this.anchorKeyPCL.remove(anchorKey));
        }
        if (this.wayAnchorKeys.contains(anchorKey)) {
            this.wayAnchorKeys.remove(anchorKey);
        }
        this.anchorsProperty.remove((Object)anchorKey);
        oldAnchor.detach(anchorKey, (IAdaptable)this.as);
    }

    public void removeWayPoint(int index) {
        if (index < 0 || index >= this.getWayAnchorsSize()) {
            throw new IllegalArgumentException("Index out of range (index: " + index + ", size: " + this.getWayAnchorsSize() + ").");
        }
        AnchorKey anchorKey = this.getWayAnchorKey(index);
        if (!this.anchorsProperty.containsKey((Object)anchorKey)) {
            throw new IllegalStateException("Inconsistent state: way anchor not in map!");
        }
        IFXAnchor oldAnchor = (IFXAnchor)this.anchorsProperty.get((Object)anchorKey);
        this.removeAnchor(anchorKey, oldAnchor);
        this.refreshGeometry();
    }

    public void setAnchors(List<IFXAnchor> anchors) {
        if (anchors.size() < 2) {
            throw new IllegalArgumentException("start end end anchors have to be provided.");
        }
        this.setStartAnchor(anchors.get(0));
        if (anchors.size() > 2) {
            this.setWayAnchors(anchors.subList(1, anchors.size() - 1));
        } else {
            this.removeAllWayPoints();
        }
        this.setEndAnchor(anchors.get(anchors.size() - 1));
    }

    public void setEndAnchor(IFXAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getEndAnchorKey();
        IFXAnchor oldAnchor = (IFXAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.removeAnchor(anchorKey, oldAnchor);
            }
            this.putAnchor(anchor, anchorKey, -1);
        }
    }

    public void setEndDecoration(IFXDecoration endDeco) {
        ObservableList styleClasses;
        this.endDecoration = endDeco;
        if (this.endDecoration != null && !(styleClasses = this.endDecoration.getVisual().getStyleClass()).contains((Object)CSS_CLASS_DECORATION)) {
            styleClasses.add((Object)CSS_CLASS_DECORATION);
        }
        this.refreshGeometry();
    }

    public void setEndPoint(Point endPointInLocal) {
        if (endPointInLocal == null) {
            endPointInLocal = new Point();
        }
        FXStaticAnchor anchor = new FXStaticAnchor((Node)this, endPointInLocal);
        this.setEndAnchor(anchor);
    }

    public void setRouter(IFXConnectionRouter router) {
        this.router = router;
        this.refreshGeometry();
    }

    public void setStartAnchor(IFXAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getStartAnchorKey();
        IFXAnchor oldAnchor = (IFXAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.removeAnchor(anchorKey, oldAnchor);
            }
            this.putAnchor(anchor, anchorKey, -1);
        }
    }

    public void setStartDecoration(IFXDecoration startDeco) {
        ObservableList styleClasses;
        this.startDecoration = startDeco;
        if (this.startDecoration != null && !(styleClasses = this.startDecoration.getVisual().getStyleClass()).contains((Object)CSS_CLASS_DECORATION)) {
            styleClasses.add((Object)CSS_CLASS_DECORATION);
        }
        this.refreshGeometry();
    }

    public void setStartPoint(Point startPointInLocal) {
        if (startPointInLocal == null) {
            startPointInLocal = new Point();
        }
        FXStaticAnchor anchor = new FXStaticAnchor((Node)this, startPointInLocal);
        this.setStartAnchor(anchor);
    }

    public void setWayAnchor(int index, IFXAnchor anchor) {
        if (index < 0 || index >= this.wayAnchorKeys.size()) {
            throw new IllegalArgumentException("index out of range.");
        }
        if (anchor == null) {
            throw new IllegalArgumentException("anchor may not be null.");
        }
        AnchorKey anchorKey = this.getWayAnchorKey(index);
        IFXAnchor oldAnchor = (IFXAnchor)this.anchorsProperty.get((Object)anchorKey);
        if (oldAnchor != anchor) {
            if (oldAnchor != null) {
                this.removeAnchor(anchorKey, oldAnchor);
            }
            this.putAnchor(anchor, anchorKey, index);
        }
    }

    public void setWayAnchors(List<IFXAnchor> anchors) {
        int wayPointsSize = this.getWayAnchorsSize();
        int i = wayPointsSize - 1;
        while (i >= anchors.size()) {
            this.removeWayPoint(i);
            --i;
        }
        i = 0;
        while (i < wayPointsSize && i < anchors.size()) {
            this.setWayAnchor(i, anchors.get(i));
            ++i;
        }
        i = wayPointsSize;
        while (i < anchors.size()) {
            this.addWayAnchor(i, anchors.get(i));
            ++i;
        }
    }

    public void setWayPoint(int index, Point wayPointInLocal) {
        if (wayPointInLocal == null) {
            wayPointInLocal = new Point();
        }
        FXStaticAnchor anchor = new FXStaticAnchor((Node)this, wayPointInLocal);
        this.setWayAnchor(index, anchor);
    }

    public void setWayPoints(List<Point> wayPoints) {
        int waySize = this.wayAnchorKeys.size();
        int i = 0;
        while (i < waySize && i < wayPoints.size()) {
            this.setWayPoint(i, wayPoints.get(i));
            ++i;
        }
        while (i < wayPoints.size()) {
            this.addWayPoint(i, wayPoints.get(i));
            ++i;
        }
        while (i < waySize) {
            this.removeWayPoint(i);
            ++i;
        }
    }

    public static class FXChopBoxHelper
    implements FXChopBoxAnchor.ReferencePointProvider {
        private ReferencePointMap referencePoints = new ReferencePointMap();
        private ReadOnlyMapWrapper<AnchorKey, Point> referencePointProperty = new ReadOnlyMapWrapper(FXCollections.observableMap((Map)this.referencePoints));
        private MapChangeListener<AnchorKey, IFXAnchor> anchorsChangeListener = new MapChangeListener<AnchorKey, IFXAnchor>(){

            public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends IFXAnchor> change) {
                IFXAnchor newAnchor;
                AnchorKey key = (AnchorKey)change.getKey();
                IFXAnchor oldAnchor = (IFXAnchor)change.getValueRemoved();
                if (oldAnchor != null && FXChopBoxHelper.this.pcls.containsKey(key)) {
                    oldAnchor.positionProperty().removeListener((MapChangeListener)FXChopBoxHelper.this.pcls.remove(key));
                    FXChopBoxHelper.this.updateReferencePoints(null);
                }
                if ((newAnchor = (IFXAnchor)change.getValueAdded()) != null) {
                    MapChangeListener pcl = FXChopBoxHelper.this.createPCL(newAnchor, key);
                    FXChopBoxHelper.this.pcls.put(key, pcl);
                    newAnchor.positionProperty().addListener(pcl);
                }
            }
        };
        private FXConnection connection;
        private Map<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>> pcls = new HashMap<AnchorKey, MapChangeListener<? super AnchorKey, ? super Point>>();

        public FXChopBoxHelper(FXConnection connection) {
            this.connection = connection;
            connection.anchorsProperty().addListener((ChangeListener)new ChangeListener<ObservableMap<AnchorKey, IFXAnchor>>(){

                public void changed(ObservableValue<? extends ObservableMap<AnchorKey, IFXAnchor>> observable, ObservableMap<AnchorKey, IFXAnchor> oldValue, ObservableMap<AnchorKey, IFXAnchor> newValue) {
                    if (oldValue == newValue) {
                        return;
                    }
                    if (oldValue != null) {
                        oldValue.removeListener(FXChopBoxHelper.this.anchorsChangeListener);
                    }
                    if (newValue != null) {
                        newValue.addListener(FXChopBoxHelper.this.anchorsChangeListener);
                    }
                }
            });
            connection.anchorsProperty().addListener(this.anchorsChangeListener);
        }

        private MapChangeListener<? super AnchorKey, ? super Point> createPCL(final IFXAnchor anchor, final AnchorKey key) {
            return new MapChangeListener<AnchorKey, Point>(){

                public void onChanged(MapChangeListener.Change<? extends AnchorKey, ? extends Point> change) {
                    if (change.wasAdded() && ((AnchorKey)change.getKey()).equals(key) && anchor.isAttached(key)) {
                        FXChopBoxHelper.this.updateReferencePoints(key);
                    }
                }
            };
        }

        private Point getCenter(Node anchorageNode) {
            Point center = JavaFX2Geometry.toRectangle((Bounds)this.connection.sceneToLocal(anchorageNode.localToScene(anchorageNode.getLayoutBounds()))).getCenter();
            if (Double.isNaN(center.x) || Double.isNaN(center.y)) {
                return null;
            }
            return center;
        }

        private Point getNeighbor(int anchorIndex, int step) {
            List<IFXAnchor> anchors = this.connection.getAnchors();
            IFXAnchor anchor = anchors.get(anchorIndex);
            if (!(anchor instanceof FXChopBoxAnchor)) {
                throw new IllegalStateException("specified anchor is no FXChopBoxAnchor");
            }
            Node anchorage = anchor.getAnchorage();
            int i = anchorIndex + step;
            while (i < anchors.size() && i >= 0) {
                IFXAnchor predAnchor = anchors.get(i);
                if (predAnchor == null) {
                    throw new IllegalStateException("connection inconsistent (null anchor)");
                }
                Node predAnchorage = predAnchor.getAnchorage();
                if (predAnchorage == null || predAnchorage == this.connection) {
                    AnchorKey anchorKey = this.connection.getAnchorKey(i);
                    Point position = predAnchor.getPosition(anchorKey);
                    if (position == null) {
                        throw new IllegalStateException("connection inconsistent (null position)");
                    }
                    Point2D local = anchorage.sceneToLocal(this.connection.localToScene(position.x, position.y));
                    if (!anchorage.contains(local)) {
                        return position;
                    }
                } else {
                    Point position = this.getCenter(predAnchorage);
                    if (position == null) {
                        throw new IllegalStateException("cannot determine anchorage center");
                    }
                    return position;
                }
                i += step;
            }
            return null;
        }

        private Point getPred(int anchorIndex) {
            return this.getNeighbor(anchorIndex, -1);
        }

        private Point getSucc(int anchorIndex) {
            return this.getNeighbor(anchorIndex, 1);
        }

        @Override
        public ReadOnlyMapWrapper<AnchorKey, Point> referencePointProperty() {
            return this.referencePointProperty;
        }

        private void updateReferencePoint(int anchorIndex, AnchorKey key) {
            if (this.connection.getStartAnchor() == null || this.connection.getEndAnchor() == null) {
                return;
            }
            if (!(this.connection.getAnchors().get(anchorIndex) instanceof FXChopBoxAnchor)) {
                return;
            }
            Point oldRef = this.referencePoints.getRaw(key);
            Point newRef = null;
            Point pred = this.getPred(anchorIndex);
            Point succ = this.getSucc(anchorIndex);
            newRef = pred == null && succ == null ? new Point() : (pred != null ? pred : (succ != null ? succ : new Line(pred, succ).get(0.5)));
            if (oldRef == null || !newRef.equals((Object)oldRef)) {
                this.referencePointProperty.put((Object)key, (Object)newRef);
            }
        }

        private void updateReferencePoints(AnchorKey key) {
            if (this.connection.getStartAnchor() == null || this.connection.getEndAnchor() == null) {
                return;
            }
            int anchorIndex = key == null ? -1 : this.connection.getAnchorIndex(key);
            List<IFXAnchor> anchors = this.connection.getAnchors();
            int i = 0;
            while (i < anchors.size()) {
                if (anchorIndex != i) {
                    this.updateReferencePoint(i, this.connection.getAnchorKey(i));
                }
                ++i;
            }
        }

        public class ReferencePointMap
        extends HashMap<AnchorKey, Point> {
            private static final long serialVersionUID = 1L;

            @Override
            public Point get(Object key) {
                if (!(key instanceof AnchorKey)) {
                    throw new IllegalArgumentException("Expected AnchorKey but got <" + key + ">");
                }
                AnchorKey ak = (AnchorKey)key;
                if (!this.containsKey(ak)) {
                    if (FXChopBoxHelper.this.connection.getStartAnchor() != null && FXChopBoxHelper.this.connection.getEndAnchor() != null) {
                        FXChopBoxHelper.this.updateReferencePoint(FXChopBoxHelper.this.connection.getAnchorIndex(ak), ak);
                    } else {
                        this.put(ak, new Point());
                    }
                }
                return (Point)super.get(ak);
            }

            public Point getRaw(Object key) {
                return (Point)super.get(key);
            }
        }
    }
}

