/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.convert.fx;

import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class JavaFX2Geometry {
    private JavaFX2Geometry() {
    }

    public static final AffineTransform toAffineTransform(Transform t) {
        return new AffineTransform(t.getMxx(), t.getMyx(), t.getMxy(), t.getMyy(), t.getTx(), t.getTy());
    }

    public static final Rectangle toRectangle(Bounds b) {
        return new Rectangle(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
    }

    public static final Point toPoint(Point2D point) {
        return new Point(point.getX(), point.getY());
    }

    public static final org.eclipse.gef4.geometry.planar.Path toPath(Path path) {
        ObservableList elements = path.getElements();
        Path.Segment[] segments = new Path.Segment[elements.size()];
        int i = 0;
        while (i < segments.length) {
            PathElement element = (PathElement)elements.get(i);
            if (element instanceof MoveTo) {
                MoveTo moveTo = (MoveTo)element;
                segments[i] = new Path.Segment(0, new Point[]{new Point(moveTo.getX(), moveTo.getY())});
            } else if (element instanceof LineTo) {
                LineTo lineTo = (LineTo)element;
                segments[i] = new Path.Segment(1, new Point[]{new Point(lineTo.getX(), lineTo.getY())});
            } else if (element instanceof QuadCurveTo) {
                QuadCurveTo quadTo = (QuadCurveTo)element;
                segments[i] = new Path.Segment(2, new Point[]{new Point(quadTo.getControlX(), quadTo.getControlY()), new Point(quadTo.getX(), quadTo.getY())});
            } else if (element instanceof CubicCurveTo) {
                CubicCurveTo cubicTo = (CubicCurveTo)element;
                segments[i] = new Path.Segment(3, new Point[]{new Point(cubicTo.getControlX1(), cubicTo.getControlY1()), new Point(cubicTo.getControlX2(), cubicTo.getControlY2()), new Point(cubicTo.getX(), cubicTo.getY())});
            } else if (element instanceof ClosePath) {
                segments[i] = new Path.Segment(4, new Point[0]);
            }
            ++i;
        }
        int windingRule = path.getFillRule() == FillRule.EVEN_ODD ? 0 : 1;
        return new org.eclipse.gef4.geometry.planar.Path(windingRule, segments);
    }
}

