/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AbstractGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IRotatable;
import org.eclipse.gef4.geometry.planar.IScalable;
import org.eclipse.gef4.geometry.planar.ITranslatable;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.internal.geometry.utils.PointListUtils;

public class PolyBezier
extends AbstractGeometry
implements ICurve,
ITranslatable<PolyBezier>,
IScalable<PolyBezier>,
IRotatable<PolyBezier> {
    public static final double INTERPOLATION_CURVE_WIDTH_COEFFICIENT = 1.0;
    private static final long serialVersionUID = 1L;
    private BezierCurve[] beziers;

    private static BezierCurve[] copy(BezierCurve ... beziers) {
        BezierCurve[] copy = new BezierCurve[beziers.length];
        int i = 0;
        while (i < beziers.length) {
            copy[i] = beziers[i].getCopy();
            ++i;
        }
        return copy;
    }

    public static PolyBezier interpolateCubic(Angle startAngle, double startLength, Angle endAngle, double endLength, double curveWidthCoefficient, Point ... wayPoints) {
        PolyBezier interpolation = PolyBezier.interpolateCubic(curveWidthCoefficient, wayPoints);
        return interpolation;
    }

    public static PolyBezier interpolateCubic(double ... coordinates) {
        Point[] points = new Point[coordinates.length / 2];
        int i = 0;
        while (i < coordinates.length / 2) {
            points[i] = new Point(coordinates[i * 2], coordinates[i * 2 + 1]);
            ++i;
        }
        return PolyBezier.interpolateCubic(points);
    }

    public static PolyBezier interpolateCubic(double curveWidthCoefficient, Point ... points) {
        if (points == null || points.length < 2) {
            throw new IllegalArgumentException("Not enough points specified (at least 2 required).");
        }
        if (points.length == 2) {
            return new PolyBezier(new Line(points[0], points[1]));
        }
        Point[] mids = new Point[points.length - 1];
        int i = 0;
        while (i < mids.length) {
            mids[i] = points[i].getTranslated(points[i + 1]).getScaled(0.5);
            ++i;
        }
        Line[] lines = PointListUtils.toSegmentsArray(points, true);
        Line[] handleLines = PointListUtils.toSegmentsArray(mids, true);
        Point[] handleAnchors = new Point[handleLines.length];
        int i2 = 0;
        while (i2 < handleLines.length) {
            double d0 = lines[i2].getP1().getDistance(lines[i2].getP2());
            double d1 = lines[i2 + 1].getP1().getDistance(lines[i2 + 1].getP2());
            handleAnchors[i2] = handleLines[i2].get(d0 / (d0 + d1));
            ++i2;
        }
        i2 = 0;
        while (i2 < handleLines.length) {
            handleLines[i2].scale(curveWidthCoefficient, handleAnchors[i2]);
            handleLines[i2].translate(points[i2 + 1].x - handleAnchors[i2].x, points[i2 + 1].y - handleAnchors[i2].y);
            ++i2;
        }
        BezierCurve[] interpolation = new CubicCurve[handleLines.length];
        interpolation[0] = new CubicCurve(points[0], handleLines[0].getP1(), points[1], points[1]);
        interpolation[interpolation.length - 1] = new CubicCurve(points[points.length - 2], handleLines[handleLines.length - 2].getP2(), points[points.length - 1], points[points.length - 1]);
        int i3 = 1;
        while (i3 < interpolation.length - 1) {
            interpolation[i3] = new CubicCurve(points[i3], handleLines[i3 - 1].getP2(), handleLines[i3].getP1(), points[i3 + 1]);
            ++i3;
        }
        return new PolyBezier(interpolation);
    }

    public static PolyBezier interpolateCubic(Point ... points) {
        PolyBezier interp = PolyBezier.interpolateCubic(1.0, points);
        return interp;
    }

    public PolyBezier(BezierCurve ... beziers) {
        this.beziers = PolyBezier.copy(beziers);
    }

    @Override
    public boolean contains(Point p) {
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            if (c.contains(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Rectangle getBounds() {
        if (this.beziers == null || this.beziers.length == 0) {
            return new Rectangle();
        }
        Rectangle bounds = this.beziers[0].getBounds();
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            bounds.union(c.getBounds());
            ++n2;
        }
        return bounds;
    }

    @Override
    public PolyBezier getCopy() {
        return new PolyBezier(this.beziers);
    }

    @Override
    public Point[] getIntersections(ICurve c) {
        return CurveUtils.getIntersections((ICurve)this, c);
    }

    @Override
    public Point getNearestIntersection(ICurve c, Point reference) {
        return CurveUtils.getNearestIntersection(this, c, reference);
    }

    @Override
    public Point getP1() {
        return this.beziers[0].getP1();
    }

    @Override
    public Point getP2() {
        return this.beziers[this.beziers.length - 1].getP2();
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle) {
        return this.getCopy().rotateCCW(angle);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, double cx, double cy) {
        return this.getCopy().getRotatedCCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, Point center) {
        return this.getCopy().getRotatedCCW(angle, center);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle) {
        return this.getCopy().getRotatedCW(angle);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, double cx, double cy) {
        return this.getCopy().getRotatedCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, Point center) {
        return this.getCopy().getRotatedCW(angle, center);
    }

    @Override
    public PolyBezier getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    @Override
    public PolyBezier getScaled(double fx, double fy) {
        return this.getCopy().scale(fx, fy);
    }

    @Override
    public PolyBezier getScaled(double factor, double cx, double cy) {
        return this.getCopy().scale(factor, cx, cy);
    }

    @Override
    public PolyBezier getScaled(double fx, double fy, double cx, double cy) {
        return this.getCopy().scale(fx, fy, cx, cy);
    }

    @Override
    public PolyBezier getScaled(double fx, double fy, Point center) {
        return this.getCopy().scale(fx, fy, center);
    }

    @Override
    public PolyBezier getScaled(double factor, Point center) {
        return this.getCopy().scale(factor, center);
    }

    @Override
    public PolyBezier getTransformed(AffineTransform t) {
        ArrayList<BezierCurve> transformedCurves = new ArrayList<BezierCurve>();
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            transformedCurves.add(c.getTransformed(t));
            ++n2;
        }
        return new PolyBezier(transformedCurves.toArray(new BezierCurve[0]));
    }

    @Override
    public PolyBezier getTranslated(double dx, double dy) {
        return this.getCopy().translate(dx, dy);
    }

    @Override
    public PolyBezier getTranslated(Point d) {
        return this.getCopy().translate(d.x, d.y);
    }

    @Override
    public double getX1() {
        return this.getP1().x;
    }

    @Override
    public double getX2() {
        return this.getP2().x;
    }

    @Override
    public double getY1() {
        return this.getP1().y;
    }

    @Override
    public double getY2() {
        return this.getP2().y;
    }

    @Override
    public boolean intersects(ICurve c) {
        return CurveUtils.intersects(c, this);
    }

    @Override
    public boolean overlaps(ICurve c) {
        return CurveUtils.overlaps(c, this);
    }

    public PolyBezier rotateCCW(Angle angle) {
        ArrayList<Point> points = new ArrayList<Point>();
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            points.addAll(Arrays.asList(c.getPoints()));
            ++n2;
        }
        Point centroid = Point.getCentroid(points.toArray(new Point[0]));
        return this.rotateCCW(angle, centroid.x, centroid.y);
    }

    public PolyBezier rotateCCW(Angle angle, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.rotateCCW(angle, cx, cy);
            ++n2;
        }
        return this;
    }

    public PolyBezier rotateCCW(Angle angle, Point center) {
        return this.rotateCCW(angle, center.x, center.y);
    }

    public PolyBezier rotateCW(Angle angle) {
        ArrayList<Point> points = new ArrayList<Point>();
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            points.addAll(Arrays.asList(c.getPoints()));
            ++n2;
        }
        Point centroid = Point.getCentroid(points.toArray(new Point[0]));
        return this.rotateCW(angle, centroid.x, centroid.y);
    }

    public PolyBezier rotateCW(Angle angle, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.rotateCW(angle, cx, cy);
            ++n2;
        }
        return this;
    }

    public PolyBezier rotateCW(Angle angle, Point center) {
        return this.rotateCW(angle, center.x, center.y);
    }

    @Override
    public PolyBezier scale(double factor) {
        return this.scale(factor, factor);
    }

    @Override
    public PolyBezier scale(double fx, double fy) {
        ArrayList<Point> points = new ArrayList<Point>();
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            points.addAll(Arrays.asList(c.getPoints()));
            ++n2;
        }
        Point centroid = Point.getCentroid(points.toArray(new Point[0]));
        return this.scale(fx, fy, centroid.x, centroid.y);
    }

    @Override
    public PolyBezier scale(double factor, double cx, double cy) {
        return this.scale(factor, factor, cx, cy);
    }

    @Override
    public PolyBezier scale(double fx, double fy, double cx, double cy) {
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.scale(fx, fy, cx, cy);
            ++n2;
        }
        return this;
    }

    @Override
    public PolyBezier scale(double fx, double fy, Point center) {
        return this.scale(fx, fx, center.x, center.y);
    }

    @Override
    public PolyBezier scale(double factor, Point center) {
        return this.scale(factor, factor, center.x, center.y);
    }

    @Override
    public BezierCurve[] toBezier() {
        return PolyBezier.copy(this.beziers);
    }

    @Override
    public Path toPath() {
        return CurveUtils.toPath(this.beziers);
    }

    @Override
    public PolyBezier translate(double dx, double dy) {
        BezierCurve[] bezierCurveArray = this.beziers;
        int n = this.beziers.length;
        int n2 = 0;
        while (n2 < n) {
            BezierCurve c = bezierCurveArray[n2];
            c.translate(dx, dy);
            ++n2;
        }
        return this;
    }

    @Override
    public PolyBezier translate(Point d) {
        return this.translate(d.x, d.y);
    }
}

