/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.internal.geometry.utils;

import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;

public class PointListUtils {
    public static double[] toCoordinatesArray(Point[] points) {
        if (points == null || points.length == 0) {
            return new double[0];
        }
        double[] coordinates = new double[points.length * 2];
        int i = 0;
        while (i < points.length) {
            coordinates[i * 2] = points[i].x;
            coordinates[i * 2 + 1] = points[i].y;
            ++i;
        }
        return coordinates;
    }

    public static int[] toIntegerArray(double[] doubles) {
        if (doubles == null || doubles.length == 0) {
            return new int[0];
        }
        int[] ints = new int[doubles.length];
        int i = 0;
        while (i < doubles.length) {
            ints[i] = (int)doubles[i];
            ++i;
        }
        return ints;
    }

    public static Point[] toPointsArray(double[] coordinates) {
        if (coordinates.length % 2 != 0) {
            throw new IllegalArgumentException("The coordinates array may not have an odd number of items.");
        }
        Point[] points = new Point[coordinates.length / 2];
        int i = 0;
        while (i < points.length) {
            points[i] = new Point(coordinates[2 * i], coordinates[2 * i + 1]);
            ++i;
        }
        return points;
    }

    public static Point[] toPointsArray(Line[] segmentsArray, boolean open) {
        if (segmentsArray == null || segmentsArray.length == 0) {
            return new Point[0];
        }
        Point[] points = new Point[segmentsArray.length + (open ? 0 : 1)];
        int i = 0;
        while (i < segmentsArray.length) {
            points[i] = segmentsArray[i].getP1();
            ++i;
        }
        if (!open) {
            points[points.length - 1] = segmentsArray[segmentsArray.length - 1].getP2();
        }
        return points;
    }

    public static Line[] toSegmentsArray(Point[] points, boolean close) {
        if (points == null || points.length < 2) {
            return new Line[0];
        }
        int segmentCount = close ? points.length : points.length - 1;
        Line[] segments = new Line[segmentCount];
        int i = 0;
        while (i < segmentCount) {
            segments[i] = new Line(points[i], points[i + 1 < points.length ? i + 1 : 0]);
            ++i;
        }
        return segments;
    }

    private PointListUtils() {
    }
}

