/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.gef4.common.notify.IListObserver;
import org.eclipse.gef4.common.notify.IMapObserver;
import org.eclipse.gef4.common.notify.ObservableList;
import org.eclipse.gef4.common.notify.ObservableMap;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Node;

public final class Graph
implements IPropertyChangeNotifier {
    public static final String ATTRIBUTES_PROPERTY = "attributes";
    public static final String NODES_PROPERTY = "nodes";
    public static final String EDGES_PROPERTY = "edges";
    private IMapObserver<String, Object> attributesObserver = new IMapObserver<String, Object>(){

        public void afterChange(ObservableMap<String, Object> observableMap, Map<String, Object> previousMap) {
            Graph.this.pcs.firePropertyChange(Graph.ATTRIBUTES_PROPERTY, previousMap, observableMap);
        }
    };
    private IListObserver<Node> nodesObserver = new IListObserver<Node>(){

        public void afterChange(ObservableList<Node> observableList, List<Node> previousList) {
            Graph.this.pcs.firePropertyChange(Graph.NODES_PROPERTY, previousList, observableList);
        }
    };
    private IListObserver<Edge> edgesObserver = new IListObserver<Edge>(){

        public void afterChange(ObservableList<Edge> observableList, List<Edge> previousList) {
            Graph.this.pcs.firePropertyChange(Graph.EDGES_PROPERTY, previousList, observableList);
        }
    };
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ObservableList<Node> nodes = new ObservableList();
    private final ObservableList<Edge> edges = new ObservableList();
    private final ObservableMap<String, Object> attrs = new ObservableMap();
    private Node nestingNode;

    public Graph() {
        this(new HashMap<String, Object>(), new ArrayList<Node>(), new ArrayList<Edge>());
    }

    public Graph(Map<String, Object> attrs, List<Node> nodes, List<Edge> edges) {
        this.attrs.putAll(attrs);
        this.attrs.addMapObserver(this.attributesObserver);
        this.nodes.addAll(nodes);
        this.nodes.addListObserver(this.nodesObserver);
        this.edges.addAll(edges);
        this.edges.addListObserver(this.edgesObserver);
        for (Node n : nodes) {
            n.setGraph(this);
        }
        for (Edge e : edges) {
            e.setGraph(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph thatGraph = (Graph)other;
        boolean attrsEqual = this.getAttrs().equals(thatGraph.getAttrs());
        boolean nodesEqual = this.getNodes().equals(thatGraph.getNodes());
        boolean edgesEqual = this.getEdges().equals(thatGraph.getEdges());
        return attrsEqual && nodesEqual && edgesEqual;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public Node getNestingNode() {
        return this.nestingNode;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.getAttrs().hashCode();
        result = 31 * result + this.getNodes().hashCode();
        result = 31 * result + this.getEdges().hashCode();
        return result;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setNestingNode(Node nestingNode) {
        this.nestingNode = nestingNode;
        if (nestingNode.getNestedGraph() != this) {
            nestingNode.setNestedGraph(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph");
        sb.append(" attr {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attrs);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attrs.get(attrKey));
        }
        sb.append("}");
        sb.append(".nodes {");
        separator = false;
        for (Node n : this.getNodes()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(n.toString());
        }
        sb.append("}");
        sb.append(".edges {");
        separator = false;
        for (Edge e : this.getEdges()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(e.toString());
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private List<Node> nodes = new ArrayList<Node>();
        private List<Edge> edges = new ArrayList<Edge>();
        private Map<String, Object> attrs = new HashMap<String, Object>();

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Graph build() {
            return new Graph(this.attrs, this.nodes, this.edges);
        }

        public Builder edges(Edge ... edges) {
            this.edges.addAll(Arrays.asList(edges));
            return this;
        }

        public Builder nodes(Node ... nodes) {
            this.nodes.addAll(Arrays.asList(nodes));
            return this;
        }
    }
}

