/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.gef4.common.notify.IMapObserver;
import org.eclipse.gef4.common.notify.ObservableMap;
import org.eclipse.gef4.common.properties.IPropertyChangeNotifier;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;

public final class Node
implements IPropertyChangeNotifier {
    public static final String ATTRIBUTES_PROPERTY = "attributes";
    private IMapObserver<String, Object> attributesObserver = new IMapObserver<String, Object>(){

        public void afterChange(ObservableMap<String, Object> observableMap, Map<String, Object> previousMap) {
            Node.this.pcs.firePropertyChange(Node.ATTRIBUTES_PROPERTY, previousMap, observableMap);
        }
    };
    protected PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final ObservableMap<String, Object> attrs = new ObservableMap();
    private Graph graph;
    private Graph nestedGraph;

    public Node() {
        this(new HashMap<String, Object>());
    }

    public Node(Map<String, Object> attrs) {
        this.attrs.putAll(attrs);
        this.attrs.addMapObserver(this.attributesObserver);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Node)) {
            return false;
        }
        boolean attrsEqual = this.getAttrs().equals(((Node)that).getAttrs());
        return attrsEqual;
    }

    public Set<? extends Edge> getAllIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set incoming = Collections.newSetFromMap(new IdentityHashMap());
        incoming.addAll(this.getLocalIncomingEdges());
        if (this.graph.getNestingNode() != null) {
            incoming.addAll(this.graph.getNestingNode().getAllIncomingEdges());
        }
        return incoming;
    }

    public Set<Node> getAllNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getAllPredecessorNodes());
        neighbors.addAll(this.getAllSuccessorNodes());
        return neighbors;
    }

    public Set<? extends Edge> getAllOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set outgoing = Collections.newSetFromMap(new IdentityHashMap());
        outgoing.addAll(this.getLocalOutgoingEdges());
        if (this.graph.getNestingNode() != null) {
            outgoing.addAll(this.graph.getNestingNode().getAllOutgoingEdges());
        }
        return outgoing;
    }

    public Set<? extends Node> getAllPredecessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set predecessors = Collections.newSetFromMap(new IdentityHashMap());
        predecessors.addAll(this.getLocalPredecessorNodes());
        if (this.graph.getNestingNode() != null) {
            predecessors.addAll(this.graph.getNestingNode().getAllPredecessorNodes());
        }
        return predecessors;
    }

    public Set<? extends Node> getAllSuccessorNodes() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set successors = Collections.newSetFromMap(new IdentityHashMap());
        successors.addAll(this.getLocalSuccessorNodes());
        if (this.graph.getNestingNode() != null) {
            successors.addAll(this.graph.getNestingNode().getAllSuccessorNodes());
        }
        return successors;
    }

    public Map<String, Object> getAttrs() {
        return this.attrs;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Set<Edge> getLocalIncomingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> incoming = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getTarget() != this) continue;
            incoming.add(e);
        }
        return incoming;
    }

    public Set<Node> getLocalNeighbors() {
        Set<Node> neighbors = Collections.newSetFromMap(new IdentityHashMap());
        neighbors.addAll(this.getLocalPredecessorNodes());
        neighbors.addAll(this.getLocalSuccessorNodes());
        return neighbors;
    }

    public Set<Edge> getLocalOutgoingEdges() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        Set<Edge> outgoing = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge e : this.graph.getEdges()) {
            if (e.getSource() != this) continue;
            outgoing.add(e);
        }
        return outgoing;
    }

    public Set<Node> getLocalPredecessorNodes() {
        Set<Node> predecessors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge incoming : this.getLocalIncomingEdges()) {
            predecessors.add(incoming.getSource());
        }
        return predecessors;
    }

    public Set<Node> getLocalSuccessorNodes() {
        Set<Node> successors = Collections.newSetFromMap(new IdentityHashMap());
        for (Edge outgoing : this.getLocalOutgoingEdges()) {
            successors.add(outgoing.getTarget());
        }
        return successors;
    }

    public Graph getNestedGraph() {
        return this.nestedGraph;
    }

    public int hashCode() {
        return this.getAttrs().hashCode();
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setNestedGraph(Graph nestedGraph) {
        this.nestedGraph = nestedGraph;
        if (nestedGraph.getNestingNode() != this) {
            nestedGraph.setNestingNode(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attrs);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attrs.get(attrKey));
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private Map<String, Object> attrs = new HashMap<String, Object>();

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Node build() {
            return new Node(this.attrs);
        }
    }
}

