/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.IEntityLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.LayoutProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalShiftAlgorithm
implements ILayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;
    private ILayoutContext context;

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        ArrayList<List<IEntityLayout>> rowsList = new ArrayList<List<IEntityLayout>>();
        IEntityLayout[] entities = this.context.getEntities();
        int i = 0;
        while (i < entities.length) {
            this.addToRowList(entities[i], rowsList);
            ++i;
        }
        Collections.sort(rowsList, new Comparator<List<IEntityLayout>>(){

            @Override
            public int compare(List<IEntityLayout> o1, List<IEntityLayout> o2) {
                IEntityLayout entity0 = o1.get(0);
                IEntityLayout entity1 = o2.get(0);
                return (int)(LayoutProperties.getLocation((IEntityLayout)entity0).y - LayoutProperties.getLocation((IEntityLayout)entity1).y);
            }
        });
        Comparator<IEntityLayout> entityComparator = new Comparator<IEntityLayout>(){

            @Override
            public int compare(IEntityLayout o1, IEntityLayout o2) {
                return (int)(LayoutProperties.getLocation((IEntityLayout)o1).y - LayoutProperties.getLocation((IEntityLayout)o2).y);
            }
        };
        Rectangle bounds = LayoutProperties.getBounds(this.context);
        int heightSoFar = 0;
        for (List<IEntityLayout> currentRow : rowsList) {
            Collections.sort(currentRow, entityComparator);
            int i2 = 0;
            int width = (int)(bounds.getWidth() / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (LayoutProperties.getSize((IEntityLayout)currentRow.get((int)0)).height + 16.0));
            for (IEntityLayout entity : currentRow) {
                Dimension size = LayoutProperties.getSize(entity);
                LayoutProperties.setLocation(entity, (double)(width + 10 * ++i2) + size.width / 2.0, (double)heightSoFar + size.height / 2.0);
                width = (int)((double)width + size.width);
            }
        }
    }

    @Override
    public void setLayoutContext(ILayoutContext context) {
        this.context = context;
    }

    @Override
    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    private void addToRowList(IEntityLayout entity, ArrayList<List<IEntityLayout>> rowsList) {
        double layoutY = LayoutProperties.getLocation((IEntityLayout)entity).y;
        for (List<IEntityLayout> currentRow : rowsList) {
            IEntityLayout currentRowEntity = currentRow.get(0);
            double currentRowY = LayoutProperties.getLocation((IEntityLayout)currentRowEntity).y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<IEntityLayout> newRow = new ArrayList<IEntityLayout>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

