/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.listeners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef4.layout.IConnectionLayout;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.ISubgraphLayout;
import org.eclipse.gef4.layout.listeners.IContextListener;
import org.eclipse.gef4.layout.listeners.IGraphStructureListener;
import org.eclipse.gef4.layout.listeners.ILayoutListener;
import org.eclipse.gef4.layout.listeners.IPruningListener;

public class LayoutListenerSupport {
    private final ILayoutContext context;
    private final List<IContextListener> contextListeners = new ArrayList<IContextListener>();
    private final List<IGraphStructureListener> graphStructureListeners = new ArrayList<IGraphStructureListener>();
    private final List<ILayoutListener> layoutListeners = new ArrayList<ILayoutListener>();
    private final List<IPruningListener> pruningListeners = new ArrayList<IPruningListener>();

    public LayoutListenerSupport(ILayoutContext context) {
        this.context = context;
    }

    public void addContextListener(IContextListener listener) {
        this.contextListeners.add(listener);
    }

    public void addGraphStructureListener(IGraphStructureListener listener) {
        this.graphStructureListeners.add(listener);
    }

    public void addLayoutListener(ILayoutListener listener) {
        this.layoutListeners.add(listener);
    }

    public void addPruningListener(IPruningListener listener) {
        this.pruningListeners.add(listener);
    }

    public void fireBackgroundEnableChangedEvent() {
        for (IContextListener listener : this.contextListeners) {
            listener.backgroundEnableChanged(this.context);
        }
    }

    public void fireBoundsChangedEvent() {
        boolean intercepted = false;
        for (IContextListener listener : this.contextListeners) {
            boolean intercept = listener.boundsChanged(this.context);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireConnectionAddedEvent(IConnectionLayout connection) {
        boolean intercepted = false;
        for (IGraphStructureListener listener : this.graphStructureListeners) {
            boolean intercept = listener.connectionAdded(this.context, connection);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireConnectionRemovedEvent(IConnectionLayout connection) {
        boolean intercepted = false;
        for (IGraphStructureListener listener : this.graphStructureListeners) {
            boolean intercept = listener.connectionRemoved(this.context, connection);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireNodeAddedEvent(INodeLayout node) {
        boolean intercepted = false;
        for (IGraphStructureListener listener : this.graphStructureListeners) {
            boolean intercept = listener.nodeAdded(this.context, node);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireNodeMovedEvent(INodeLayout node) {
        boolean intercepted = false;
        for (ILayoutListener listener : this.layoutListeners) {
            boolean intercept = listener.nodeMoved(this.context, node);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireNodeRemovedEvent(INodeLayout node) {
        boolean intercepted = false;
        for (IGraphStructureListener listener : this.graphStructureListeners) {
            boolean intercept = listener.nodeRemoved(this.context, node);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireNodeResizedEvent(INodeLayout node) {
        boolean intercepted = false;
        for (ILayoutListener listener : this.layoutListeners) {
            boolean intercept = listener.nodeResized(this.context, node);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void firePruningEnableChangedEvent() {
        for (IContextListener listener : this.contextListeners) {
            listener.pruningEnablementChanged(this.context);
        }
    }

    public void fireSubgraphMovedEvent(ISubgraphLayout subgraph) {
        boolean intercepted = false;
        for (ILayoutListener listener : this.layoutListeners) {
            boolean intercept = listener.subgraphMoved(this.context, subgraph);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void fireSubgraphResizedEvent(ISubgraphLayout subgraph) {
        boolean intercepted = false;
        for (ILayoutListener listener : this.layoutListeners) {
            boolean intercept = listener.subgraphResized(this.context, subgraph);
            if (intercepted) continue;
            intercepted = intercept;
        }
        if (!intercepted) {
            this.context.applyDynamicLayout(true);
        }
    }

    public void removeContextListener(IContextListener listener) {
        this.contextListeners.remove(listener);
    }

    public void removeGraphStructureListener(IGraphStructureListener listener) {
        this.graphStructureListeners.remove(listener);
    }

    public void removeLayoutListener(ILayoutListener listener) {
        this.layoutListeners.remove(listener);
    }

    public void removePruningListener(IPruningListener listener) {
        this.pruningListeners.remove(listener);
    }
}

