/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.fx.nodes.FXGeometryNode;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricModel;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;
import org.eclipse.gef4.mvc.examples.logo.policies.IFXCreationMenuItem;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;

public class FXCreationMenuItemProvider
implements Provider<List<IFXCreationMenuItem>> {
    public List<IFXCreationMenuItem> get() {
        ArrayList<IFXCreationMenuItem> items = new ArrayList<IFXCreationMenuItem>();
        items.add(new GeometricShapeItem(new FXGeometricShape(FXGeometricModel.createHandleShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0), (Paint)Color.WHITE, FXGeometricModel.GEF_SHADOW_EFFECT)));
        items.add(new GeometricShapeItem(new FXGeometricShape(FXGeometricModel.createEShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 100.0, 22.0), (Paint)FXGeometricModel.GEF_COLOR_BLUE, FXGeometricModel.GEF_SHADOW_EFFECT)));
        items.add(new GeometricShapeItem(new FXGeometricShape(FXGeometricModel.createCursorShapeGeometry(), new AffineTransform(1.0, 0.0, 0.0, 1.0, 227.0, 45.0), Color.WHITE, 2.0, (Paint)Color.BLACK, FXGeometricModel.GEF_SHADOW_EFFECT)));
        return items;
    }

    static class GeometricShapeItem
    implements IFXCreationMenuItem {
        private final FXGeometricShape template;

        public GeometricShapeItem(FXGeometricShape content) {
            this.template = content;
        }

        @Override
        public Object createContent() {
            FXGeometricShape content = new FXGeometricShape((IShape)this.template.getGeometry(), this.template.getTransform(), this.template.getFill(), this.template.getEffect());
            content.setStroke(this.template.getStroke());
            content.setStrokeWidth(this.template.getStrokeWidth());
            return content;
        }

        @Override
        public Node createVisual() {
            FXGeometryNode visual = new FXGeometryNode((IGeometry)((IShape)this.template.getGeometry()));
            visual.setStroke(this.template.getStroke());
            visual.setStrokeWidth(this.template.getStrokeWidth());
            visual.setFill(this.template.getFill());
            visual.setEffect(this.template.getEffect());
            return visual;
        }

        @Override
        public IContentPart<Node, ? extends Node> findContentParent(IRootPart<Node, ? extends Node> rootPart) {
            return (IContentPart)rootPart.getContentPartChildren().get(0);
        }
    }
}

