/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.convert.fx.JavaFX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricShape;
import org.eclipse.gef4.mvc.examples.logo.parts.FXGeometricShapePart;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;

public class FXTransformShapePolicy
extends FXTransformPolicy {
    public IUndoableOperation commit() {
        IUndoableOperation updateVisualOperation = super.commit();
        if (updateVisualOperation == null) {
            return null;
        }
        FXGeometricShapePart host = this.getHost();
        final FXGeometricShape hostContent = host.getContent();
        Provider affineProvider = (Provider)host.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends Affine>>(){}, (String)"transformationProvider"));
        AffineTransform tx = JavaFX2Geometry.toAffineTransform((Transform)((Transform)affineProvider.get()));
        final AffineTransform oldTransform = hostContent.getTransform();
        final AffineTransform newTransform = new AffineTransform(tx.getM00(), tx.getM10(), tx.getM01(), tx.getM11(), tx.getTranslateX(), tx.getTranslateY());
        AbstractOperation updateModelOperation = new AbstractOperation("Update Model"){

            public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                hostContent.setTransform(newTransform);
                return Status.OK_STATUS;
            }

            public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                return this.execute(monitor, info);
            }

            public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                hostContent.setTransform(oldTransform);
                return Status.OK_STATUS;
            }
        };
        ForwardUndoCompositeOperation compositeOperation = new ForwardUndoCompositeOperation(updateVisualOperation.getLabel(), updateVisualOperation, (IUndoableOperation)updateModelOperation){
            {
                this.add(iUndoableOperation);
                this.add(iUndoableOperation2);
            }
        };
        return compositeOperation;
    }

    public FXGeometricShapePart getHost() {
        return (FXGeometricShapePart)super.getHost();
    }
}

