/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.examples;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javafx.application.Application;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import org.eclipse.gef4.common.inject.AdaptableScopes;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.layout.algorithms.SugiyamaLayoutAlgorithm;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IContentPartFactory;
import org.eclipse.gef4.zest.examples.AbstractZestExample;
import org.eclipse.gef4.zest.fx.ZestFxModule;
import org.eclipse.gef4.zest.fx.parts.ContentPartFactory;
import org.eclipse.gef4.zest.fx.parts.NodeContentPart;

public class CustomNodeExample
extends AbstractZestExample {
    private static final String ATTR_CUSTOM = "isCustom";

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    public CustomNodeExample() {
        super("GEF4 Zest - Custom Node Example");
    }

    @Override
    protected Graph createGraph() {
        Graph g = new Graph();
        CustomNodeExample.e(g, CustomNodeExample.n(g, new Object[]{"label", "A", ATTR_CUSTOM, true}), CustomNodeExample.n(g, new Object[]{"label", "B"}), new Object[0]);
        g.getAttrs().put("layout", new SugiyamaLayoutAlgorithm());
        return g;
    }

    @Override
    protected Module createModule() {
        return new CustomModule();
    }

    public static class CustomContentPartFactory
    extends ContentPartFactory {
        @Inject
        private Injector injector;

        public IContentPart<Node, ? extends Node> createContentPart(Object content, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap) {
            org.eclipse.gef4.graph.Node n;
            Object isCustom;
            if (content instanceof org.eclipse.gef4.graph.Node && (isCustom = (n = (org.eclipse.gef4.graph.Node)content).getAttrs().get(CustomNodeExample.ATTR_CUSTOM)) instanceof Boolean && ((Boolean)isCustom).booleanValue()) {
                CustomNodeContentPart part = new CustomNodeContentPart();
                if (part != null) {
                    this.injector.injectMembers((Object)part);
                }
                return part;
            }
            return super.createContentPart(content, contextBehavior, contextMap);
        }
    }

    public static class CustomModule
    extends ZestFxModule {
        protected void bindIContentPartFactory() {
            this.binder().bind((TypeLiteral)new TypeLiteral<IContentPartFactory<Node>>(){}).to(CustomContentPartFactory.class).in((Scope)AdaptableScopes.typed(FXViewer.class));
        }
    }

    public static class CustomNodeContentPart
    extends NodeContentPart {
        private VBox vbox;

        protected void createNodeVisual(Group group, Rectangle rect, ImageView iconImageView, Text labelText, StackPane nestedContentStackPane) {
            ImageView ian = new ImageView(new Image(((Object)((Object)this)).getClass().getResource("ibull.jpg").toExternalForm()));
            Polyline body = new Polyline(new double[]{0.0, 0.0, 0.0, 60.0, 25.0, 90.0, 0.0, 60.0, -25.0, 90.0, 0.0, 60.0, 0.0, 25.0, 25.0, 0.0, 0.0, 25.0, -25.0, 0.0});
            body.setTranslateX(ian.getLayoutBounds().getWidth() / 2.0 - body.getLayoutBounds().getWidth() / 2.0 - 5.0);
            body.setTranslateY(-15.0);
            this.vbox = new VBox();
            this.vbox.getChildren().addAll((Object[])new Node[]{ian, body, labelText, iconImageView, nestedContentStackPane});
            group.getChildren().add((Object)this.vbox);
            labelText.setFill((Paint)Color.BLACK);
        }
    }
}

