/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.cloudio.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef4.cloudio.internal.ui.ICloudLabelProvider;
import org.eclipse.gef4.cloudio.internal.ui.TagCloud;
import org.eclipse.gef4.cloudio.internal.ui.Word;
import org.eclipse.gef4.cloudio.internal.ui.layout.ILayouter;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;

public class TagCloudViewer
extends ContentViewer {
    private TagCloud cloud;
    private Set<Word> selection = new HashSet<Word>();
    private Map<Object, Word> objectMap = new HashMap<Object, Word>();
    private int maxWords = 300;
    private IProgressMonitor monitor;

    public TagCloudViewer(TagCloud cloud) {
        Assert.isLegal((cloud != null ? 1 : 0) != 0, (String)"TagCloud must not be null!");
        Assert.isLegal((!cloud.isDisposed() ? 1 : 0) != 0, (String)"TagCloud must not be disposed!");
        this.cloud = cloud;
        this.initListeners();
    }

    protected void initListeners() {
        this.initSelectionListener();
        this.initMouseWheelListener();
        this.initToolTipSupport();
    }

    protected void initToolTipSupport() {
        this.cloud.addMouseTrackListener(new MouseTrackListener(){

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                TagCloudViewer.this.cloud.setToolTipText(null);
            }

            public void mouseEnter(MouseEvent e) {
                Word word = (Word)e.data;
                ICloudLabelProvider labelProvider = (ICloudLabelProvider)TagCloudViewer.this.getLabelProvider();
                TagCloudViewer.this.cloud.setToolTipText(labelProvider.getToolTip(word.data));
            }
        });
    }

    protected void initMouseWheelListener() {
        this.cloud.addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if (e.count > 0) {
                    TagCloudViewer.this.cloud.zoomIn();
                } else {
                    TagCloudViewer.this.cloud.zoomOut();
                }
            }
        });
    }

    protected void initSelectionListener() {
        this.cloud.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                Word word = (Word)e.data;
                if (word == null) {
                    return;
                }
                boolean remove = TagCloudViewer.this.selection.remove(word);
                if (!remove) {
                    TagCloudViewer.this.selection.add(word);
                }
                TagCloudViewer.this.cloud.setSelection(TagCloudViewer.this.selection);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.cloud.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<Object> data = new ArrayList<Object>();
                Set selected = (Set)e.data;
                for (Word word : selected) {
                    if (word.data == null) continue;
                    data.add(word.data);
                }
                StructuredSelection selection = new StructuredSelection(data);
                TagCloudViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)TagCloudViewer.this, (ISelection)selection));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public Control getControl() {
        return this.getCloud();
    }

    public ISelection getSelection() {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Word word : this.selection) {
            elements.add(word.data);
        }
        return new StructuredSelection(elements);
    }

    public void refresh() {
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.selection.clear();
        IStructuredSelection sel = (IStructuredSelection)selection;
        for (Object next : sel) {
            Word word = this.objectMap.get(next);
            if (word == null) continue;
            this.selection.add(word);
        }
        this.cloud.setSelection(this.selection);
    }

    public void reset(IProgressMonitor monitor, boolean recalc) {
        this.cloud.layoutCloud(monitor, recalc);
    }

    public TagCloud getCloud() {
        return this.cloud;
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
        Assert.isLegal((boolean)(labelProvider instanceof ICloudLabelProvider));
    }

    public void setContentProvider(IContentProvider contentProvider) {
        Assert.isLegal((boolean)(contentProvider instanceof IStructuredContentProvider));
        super.setContentProvider(contentProvider);
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.selection.clear();
        this.objectMap.clear();
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getContentProvider();
        Object[] elements = contentProvider.getElements(input);
        ArrayList<Word> words = new ArrayList<Word>();
        ICloudLabelProvider labelProvider = (ICloudLabelProvider)this.getLabelProvider();
        int i = 0;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            Word word = new Word(labelProvider.getLabel(element));
            word.setColor(labelProvider.getColor(element));
            word.weight = labelProvider.getWeight(element);
            word.setFontData(labelProvider.getFontData(element));
            word.angle = labelProvider.getAngle(element);
            word.data = element;
            Assert.isLegal((word.string != null ? 1 : 0) != 0, (String)"Labelprovider must return a String for each element");
            Assert.isLegal((word.getColor() != null ? 1 : 0) != 0, (String)"Labelprovider must return a Color for each element");
            Assert.isLegal((word.getFontData() != null ? 1 : 0) != 0, (String)"Labelprovider must return a FontData for each element");
            Assert.isLegal((word.weight >= 0.0 ? 1 : 0) != 0, (String)("Labelprovider must return a weight between 0 and 1 (inclusive), but value was " + word.weight));
            Assert.isLegal((word.weight <= 1.0 ? 1 : 0) != 0, (String)("Labelprovider must return a weight between 0 and 1 (inclusive), but value was " + word.weight));
            Assert.isLegal((word.angle >= -90.0f ? 1 : 0) != 0, (String)("Angle of an element must be between -90 and +90 (inclusive), but was " + word.angle));
            Assert.isLegal((word.angle <= 90.0f ? 1 : 0) != 0, (String)("Angle of an element must be between -90 and +90 (inclusive), but was " + word.angle));
            words.add(word);
            i = (short)(i + 1);
            word.id = (short)i;
            this.objectMap.put(element, word);
            if (i == this.maxWords) break;
            ++n2;
        }
        this.selection.clear();
        if (this.monitor != null) {
            this.monitor.subTask("Layouting...");
        }
        this.cloud.setWords(words, this.monitor);
    }

    public void setMaxWords(int words) {
        this.maxWords = words;
    }

    public void zoomFit() {
        this.cloud.zoomFit();
    }

    public void zoomIn() {
        this.cloud.zoomIn();
    }

    public void zoomOut() {
        this.cloud.zoomOut();
    }

    public void zoomReset() {
        this.cloud.zoomReset();
    }

    public void setBoost(int boost) {
        this.cloud.setBoost(boost);
    }

    public int getMaxWords() {
        return this.maxWords;
    }

    public void setInput(Object input, IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
        super.setInput(input);
        this.monitor = null;
    }

    public void setBoostFactor(float boostFactor) {
        this.cloud.setBoostFactor(boostFactor);
    }

    public void setLayouter(ILayouter layouter) {
        this.cloud.setLayouter(layouter);
    }

    public ILayouter getLayouter() {
        return this.cloud.getLayouter();
    }
}

