/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.cloudio.internal.ui.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.gef4.cloudio.internal.ui.CloudioUiBundle;
import org.eclipse.gef4.cloudio.internal.ui.TagCloudViewer;
import org.eclipse.gef4.cloudio.internal.ui.Word;
import org.eclipse.gef4.cloudio.internal.ui.view.IEditableCloudLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CloudOptionsComposite
extends Composite {
    protected TagCloudViewer viewer;
    protected List<RGB> colors = new ArrayList<RGB>();
    protected List<FontData> fonts = new ArrayList<FontData>();
    protected List<List<RGB>> colorSchemes = new ArrayList<List<RGB>>();
    protected int currentScheme;

    public CloudOptionsComposite(Composite parent, int style, TagCloudViewer viewer) {
        super(parent, style);
        Assert.isLegal((boolean)(viewer.getLabelProvider() instanceof IEditableCloudLabelProvider), (String)("Cloud label provider must be of type " + IEditableCloudLabelProvider.class));
        this.viewer = viewer;
        this.setLayout((Layout)new GridLayout());
        this.addGroups();
    }

    protected void addGroups() {
        this.addLayoutButtons(this);
        this.addColorButtons(this);
        this.addFontButtons(this);
    }

    protected void addScheme(RGB ... rgbs) {
        ArrayList<RGB> colors = new ArrayList<RGB>();
        RGB[] rGBArray = rgbs;
        int n = rgbs.length;
        int n2 = 0;
        while (n2 < n) {
            RGB rgb = rGBArray[n2];
            colors.add(rgb);
            ++n2;
        }
        this.colorSchemes.add(colors);
    }

    protected void updateColors() {
        IEditableCloudLabelProvider lp = (IEditableCloudLabelProvider)this.viewer.getLabelProvider();
        lp.setColors(this.colors);
        List<Word> words = this.viewer.getCloud().getWords();
        for (Word word : words) {
            word.setColor(lp.getColor(word.data));
        }
        this.viewer.getCloud().redrawTextLayerImage();
    }

    protected void updateFonts() {
        IEditableCloudLabelProvider lp = (IEditableCloudLabelProvider)this.viewer.getLabelProvider();
        lp.setFonts(this.fonts);
    }

    protected void initColors() {
        this.addScheme(new RGB(222, 177, 17), new RGB(97, 28, 24), new RGB(102, 109, 17), new RGB(189, 112, 20), new RGB(111, 92, 16), new RGB(111, 32, 27));
        this.addScheme(new RGB(1, 175, 255), new RGB(57, 99, 213), new RGB(21, 49, 213), new RGB(30, 125, 42));
        this.addScheme(new RGB(255, 92, 93), new RGB(255, 0, 0), new RGB(255, 41, 43), new RGB(182, 31, 32), new RGB(153, 0, 0));
        this.addScheme(new RGB(255, 157, 0), new RGB(255, 206, 0), new RGB(40, 0, 159), new RGB(0, 41, 156));
        this.addScheme(new RGB(255, 46, 0), new RGB(255, 255, 14), new RGB(183, 183, 183), new RGB(122, 122, 122), new RGB(81, 81, 81), new RGB(61, 61, 61), new RGB(165, 165, 165));
        this.addScheme(new RGB(255, 0, 206), new RGB(255, 220, 0), new RGB(0, 255, 42));
        this.addScheme(new RGB(89, 79, 69), new RGB(168, 165, 126), new RGB(68, 49, 14), new RGB(86, 68, 34), new RGB(148, 141, 129), new RGB(92, 90, 41));
        this.addScheme(new RGB(66, 71, 37), new RGB(85, 122, 18), new RGB(117, 131, 49), new RGB(49, 45, 17));
        this.addScheme(new RGB(254, 213, 44), new RGB(255, 177, 10), new RGB(233, 121, 0), new RGB(229, 109, 3), new RGB(202, 80, 8), new RGB(129, 52, 7), new RGB(89, 47, 14));
        this.addScheme(new RGB(139, 124, 115), new RGB(91, 95, 129), new RGB(50, 23, 18), new RGB(255, 251, 237));
        this.nextColors();
    }

    protected void nextColors() {
        this.currentScheme = (this.currentScheme + 1) % this.colorSchemes.size();
        this.colors = this.colorSchemes.get(this.currentScheme);
    }

    protected Group addFontButtons(final Composite parent) {
        Group buttons = new Group(parent, 4);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(4, 128, true, false));
        Label l = new Label((Composite)buttons, 0);
        l.setText("Fonts");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        final TreeViewer tv = new TreeViewer((Composite)buttons);
        Composite comp = new Composite((Composite)buttons, 0);
        comp.setLayoutData((Object)new GridData(4, 128, false, true));
        comp.setLayout((Layout)new RowLayout(512));
        tv.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ListContentProvider cp = new ListContentProvider();
        tv.setContentProvider((IContentProvider)cp);
        tv.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                FontData fd = (FontData)element;
                return fd.getName();
            }
        });
        this.fonts.add(this.getFont().getFontData()[0]);
        tv.setInput(this.fonts);
        Button add = new Button(comp, 0x800000);
        add.setImage(CloudioUiBundle.getDefault().getImageRegistry().get("add.gif"));
        add.setToolTipText("Add font...");
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontDialog fd = new FontDialog(parent.getShell());
                FontData fontData = fd.open();
                if (fontData != null) {
                    CloudOptionsComposite.this.fonts.add(fontData);
                    tv.setInput(CloudOptionsComposite.this.fonts);
                    CloudOptionsComposite.this.updateFonts();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button remove = new Button(comp, 0x800000);
        remove.setToolTipText("Remove selected fonts");
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
                CloudOptionsComposite.this.fonts.removeAll(selection.toList());
                tv.setInput(CloudOptionsComposite.this.fonts);
                CloudOptionsComposite.this.updateFonts();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        remove.setImage(CloudioUiBundle.getDefault().getImageRegistry().get("remove.gif"));
        return buttons;
    }

    protected Image createImageFromColor(RGB rgb, int size) {
        Color color = new Color((Device)Display.getDefault(), rgb);
        Image image = new Image((Device)Display.getDefault(), size, size);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.fillRoundRectangle(0, 0, size, size, 3, 3);
        color.dispose();
        gc.dispose();
        return image;
    }

    protected Group addColorButtons(final Composite parent) {
        Group buttons = new Group(parent, 4);
        buttons.setLayout((Layout)new GridLayout(2, false));
        buttons.setLayoutData((Object)new GridData(4, 128, true, false));
        Label l = new Label((Composite)buttons, 0);
        l.setText("Colors");
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        final TreeViewer tv = new TreeViewer((Composite)buttons);
        Composite comp = new Composite((Composite)buttons, 0);
        comp.setLayout((Layout)new RowLayout(512));
        comp.setLayoutData((Object)new GridData(4, 128, false, true));
        tv.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        ListContentProvider cp = new ListContentProvider();
        tv.setContentProvider((IContentProvider)cp);
        tv.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){
            private Map<Object, Image> images = new HashMap<Object, Image>();

            public Image getImage(Object element) {
                Image image = this.images.get(element);
                if (image == null) {
                    RGB rgb = (RGB)element;
                    image = CloudOptionsComposite.this.createImageFromColor(rgb, 24);
                    this.images.put(element, image);
                }
                return image;
            }

            public void dispose() {
                Collection<Image> images = this.images.values();
                for (Image image : images) {
                    image.dispose();
                }
                this.images.clear();
            }
        });
        this.initColors();
        tv.setInput(this.colors);
        Button add = new Button(comp, 0x800000);
        add.setImage(CloudioUiBundle.getDefault().getImageRegistry().get("add.gif"));
        add.setToolTipText("Add color...");
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(parent.getShell());
                RGB color = cd.open();
                if (color != null) {
                    CloudOptionsComposite.this.colors.add(color);
                    tv.setInput(CloudOptionsComposite.this.colors);
                    CloudOptionsComposite.this.updateColors();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button remove = new Button(comp, 0x800000);
        remove.setToolTipText("Remove selected colors");
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
                CloudOptionsComposite.this.colors.removeAll(selection.toList());
                tv.setInput(CloudOptionsComposite.this.colors);
                CloudOptionsComposite.this.updateColors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        remove.setImage(CloudioUiBundle.getDefault().getImageRegistry().get("remove.gif"));
        Button toggle = new Button(comp, 0x800000);
        toggle.setToolTipText("Toggle Colors");
        toggle.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CloudOptionsComposite.this.nextColors();
                tv.setInput(CloudOptionsComposite.this.colors);
                CloudOptionsComposite.this.updateColors();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        toggle.setImage(CloudioUiBundle.getDefault().getImageRegistry().get("toggle_colors.gif"));
        comp = new Composite((Composite)buttons, 0);
        gd = new GridData(4, 4, true, false);
        gd.horizontalSpan = 2;
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setLayoutData((Object)gd);
        final Button bg = new Button(comp, 0x800000);
        bg.setLayoutData((Object)new GridData(4, 4, true, false));
        bg.setText("Background");
        bg.setImage(this.createImageFromColor(this.viewer.getCloud().getBackground().getRGB(), 16));
        bg.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(parent.getShell());
                RGB color = cd.open();
                if (color == null) {
                    return;
                }
                Color old = CloudOptionsComposite.this.viewer.getCloud().getBackground();
                Color c = new Color((Device)Display.getDefault(), color);
                CloudOptionsComposite.this.viewer.getCloud().setBackground(c);
                old.dispose();
                CloudOptionsComposite.this.viewer.getCloud().redrawTextLayerImage();
                Image oldImage = bg.getImage();
                Image newImage = CloudOptionsComposite.this.createImageFromColor(color, 16);
                bg.setImage(newImage);
                oldImage.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Button sel = new Button(comp, 0x800000);
        sel.setLayoutData((Object)new GridData(4, 4, true, false));
        sel.setText("Selection");
        sel.setImage(this.createImageFromColor(this.viewer.getCloud().getSelectionColor().getRGB(), 16));
        sel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(parent.getShell());
                RGB color = cd.open();
                if (color == null) {
                    return;
                }
                Color old = CloudOptionsComposite.this.viewer.getCloud().getSelectionColor();
                Color c = new Color((Device)Display.getDefault(), color);
                CloudOptionsComposite.this.viewer.getCloud().setSelectionColor(c);
                old.dispose();
                CloudOptionsComposite.this.viewer.getCloud().redrawTextLayerImage();
                Image oldImage = sel.getImage();
                Image newImage = CloudOptionsComposite.this.createImageFromColor(color, 16);
                sel.setImage(newImage);
                oldImage.dispose();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return buttons;
    }

    protected Group addLayoutButtons(Composite parent) {
        Group buttons = new Group(parent, 4);
        buttons.setLayout((Layout)new GridLayout(2, true));
        buttons.setLayoutData((Object)new GridData(4, 128, true, false));
        Label l = new Label((Composite)buttons, 0);
        l.setText("Number of Words");
        final Combo words = new Combo((Composite)buttons, 12);
        words.setLayoutData((Object)new GridData(4, 128, true, false));
        words.setItems(new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"});
        words.select(2);
        words.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = words.getItem(words.getSelectionIndex());
                CloudOptionsComposite.this.viewer.setMaxWords(Integer.parseInt(item));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        l = new Label((Composite)buttons, 0);
        l.setText("Max Font Size");
        final Combo font = new Combo((Composite)buttons, 12);
        font.setLayoutData((Object)new GridData(4, 128, true, false));
        font.setItems(new String[]{"50", "100", "150", "200", "250", "300", "350", "400", "450", "500"});
        font.select(1);
        font.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = font.getItem(font.getSelectionIndex());
                CloudOptionsComposite.this.viewer.getCloud().setMaxFontSize(Integer.parseInt(item));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        l = new Label((Composite)buttons, 0);
        l.setText("Min Font Size");
        final Combo minFont = new Combo((Composite)buttons, 12);
        minFont.setLayoutData((Object)new GridData(4, 128, true, false));
        minFont.setItems(new String[]{"10", "15", "20", "25", "30", "35", "40", "45", "50"});
        minFont.select(1);
        minFont.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = minFont.getItem(minFont.getSelectionIndex());
                CloudOptionsComposite.this.viewer.getCloud().setMinFontSize(Integer.parseInt(item));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        l = new Label((Composite)buttons, 0);
        l.setText("Boost");
        final Combo boost = new Combo((Composite)buttons, 12);
        boost.setLayoutData((Object)new GridData(4, 128, true, false));
        boost.setItems(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"});
        boost.select(0);
        boost.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = boost.getItem(boost.getSelectionIndex());
                CloudOptionsComposite.this.viewer.setBoost(Integer.parseInt(item));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        l = new Label((Composite)buttons, 0);
        l.setText("Boost Factor");
        final Combo boostFactor = new Combo((Composite)buttons, 12);
        boostFactor.setLayoutData((Object)new GridData(4, 128, true, false));
        boostFactor.setItems(new String[]{"1", "1.5", "2", "2.5", "3", "3.5", "4", "4.5", "5"});
        boostFactor.select(0);
        boostFactor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String item = boostFactor.getItem(boostFactor.getSelectionIndex());
                CloudOptionsComposite.this.viewer.setBoostFactor(Float.parseFloat(item));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boolean cfr_ignored_0 = this.viewer.getLabelProvider() instanceof IEditableCloudLabelProvider;
        l = new Label((Composite)buttons, 0);
        l.setText("Angles");
        final Combo angles = new Combo((Composite)buttons, 12);
        angles.setLayoutData((Object)new GridData(4, 128, true, false));
        angles.setItems(new String[]{"Horizontal only", "Vertical only", "Horizontal & Vertical", "45 Degrees, mostly horizontal", "45 Degrees", "Random"});
        final ArrayList<List<Float>> anglesLists = new ArrayList<List<Float>>();
        anglesLists.add(Arrays.asList(Float.valueOf(0.0f)));
        anglesLists.add(Arrays.asList(Float.valueOf(-90.0f), Float.valueOf(90.0f)));
        anglesLists.add(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-90.0f), Float.valueOf(0.0f), Float.valueOf(90.0f)));
        anglesLists.add(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(-90.0f), Float.valueOf(-45.0f), Float.valueOf(0.0f), Float.valueOf(45.0f), Float.valueOf(90.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        anglesLists.add(Arrays.asList(Float.valueOf(-90.0f), Float.valueOf(-45.0f), Float.valueOf(0.0f), Float.valueOf(45.0f), Float.valueOf(90.0f)));
        ArrayList<Float> tmp = new ArrayList<Float>();
        int i = -90;
        while (i <= 90) {
            tmp.add(Float.valueOf(i));
            ++i;
        }
        anglesLists.add(tmp);
        angles.select(0);
        angles.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = angles.getSelectionIndex();
                IEditableCloudLabelProvider lp = (IEditableCloudLabelProvider)CloudOptionsComposite.this.viewer.getLabelProvider();
                lp.setAngles((List)anglesLists.get(index));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return buttons;
    }

    public List<RGB> getColors() {
        return this.colors;
    }

    public List<FontData> getFonts() {
        return this.fonts;
    }

    private static class ListContentProvider
    implements ITreeContentProvider {
        private ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

