/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.jface;

import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import org.eclipse.gef4.fx.jface.FXPaintUtils;
import org.eclipse.gef4.fx.swt.controls.FXAdvancedLinearGradientPicker;
import org.eclipse.gef4.fx.swt.controls.FXColorPicker;
import org.eclipse.gef4.fx.swt.controls.FXSimpleLinearGradientPicker;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class FXPaintSelectionDialog
extends Dialog {
    private Paint paint;
    private String title;
    private Combo optionsCombo;
    private Label imageLabel;
    private Paint lastFillColor = Color.WHITE;
    private FXColorPicker colorPicker;
    private Paint lastSimpleGradient = FXSimpleLinearGradientPicker.createSimpleLinearGradient((Color)Color.WHITE, (Color)Color.BLACK);
    private FXSimpleLinearGradientPicker simpleGradientPicker;
    private Paint lastAdvancedGradient = FXAdvancedLinearGradientPicker.createAdvancedLinearGradient((Color)Color.WHITE, (Color)Color.GREY, (Color)Color.BLACK);
    private FXAdvancedLinearGradientPicker advancedGradientPicker;

    public FXPaintSelectionDialog(Shell parent, String title) {
        super(parent);
        this.title = title;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected Control createAdvancedGradientFillControl(Composite parent) {
        this.advancedGradientPicker = new FXAdvancedLinearGradientPicker(parent, Color.WHITE, Color.GREY, Color.BLACK);
        this.advancedGradientPicker.setLayoutData((Object)new GridData(4, 4, true, true));
        this.advancedGradientPicker.advancedLinearGradientProperty().addListener((ChangeListener)new ChangeListener<LinearGradient>(){

            public void changed(ObservableValue<? extends LinearGradient> observable, LinearGradient oldValue, LinearGradient newValue) {
                FXPaintSelectionDialog.this.setPaint((Paint)newValue);
            }
        });
        return this.advancedGradientPicker;
    }

    protected Control createColorFillControl(Composite parent) {
        this.colorPicker = new FXColorPicker(parent, Color.WHITE);
        this.colorPicker.colorProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                FXPaintSelectionDialog.this.setPaint((Paint)newValue);
            }
        });
        return this.colorPicker;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setBackground(parent.getBackground());
        container.setFont(parent.getFont());
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = this.convertHorizontalDLUsToPixels(7);
        gl.marginTop = this.convertVerticalDLUsToPixels(7);
        container.setLayout((Layout)gl);
        Composite labelContainer = new Composite(container, 0);
        labelContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        gl = new GridLayout(2, true);
        gl.marginWidth = 3;
        labelContainer.setLayout((Layout)gl);
        Label fillLabel = new Label(labelContainer, 16384);
        fillLabel.setBackground(parent.getBackground());
        fillLabel.setFont(parent.getFont());
        fillLabel.setLayoutData((Object)new GridData());
        fillLabel.setText("Fill:");
        this.imageLabel = new Label(labelContainer, 131072);
        this.imageLabel.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        Composite optionsContainer = new Composite(container, 0);
        optionsContainer.setBackground(parent.getBackground());
        optionsContainer.setLayoutData((Object)new GridData(4, 128, true, false));
        gl = new GridLayout(1, true);
        gl.marginWidth = 3;
        optionsContainer.setLayout((Layout)gl);
        this.optionsCombo = new Combo(optionsContainer, 2060);
        this.optionsCombo.setItems(new String[]{"No Fill", "Color Fill", "Gradient Fill", "Advanced Gradient Fill"});
        this.optionsCombo.setLayoutData((Object)new GridData(1, 1, false, false));
        Composite optionsComposite = new Composite(optionsContainer, 0);
        optionsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        optionsComposite.setBackground(parent.getBackground());
        final StackLayout sl = new StackLayout();
        optionsComposite.setLayout((Layout)sl);
        Composite noFillControl = new Composite(optionsComposite, 0);
        Control colorFillControl = this.createColorFillControl(optionsComposite);
        Control simpleGradientFillControl = this.createSimpleGradientFillControl(optionsComposite);
        Control advancedGradientFillControl = this.createAdvancedGradientFillControl(optionsComposite);
        this.optionsCombo.addModifyListener(new ModifyListener((Control)noFillControl, colorFillControl, simpleGradientFillControl, advancedGradientFillControl, optionsComposite){
            private final /* synthetic */ Control val$noFillControl;
            private final /* synthetic */ Control val$colorFillControl;
            private final /* synthetic */ Control val$simpleGradientFillControl;
            private final /* synthetic */ Control val$advancedGradientFillControl;
            private final /* synthetic */ Composite val$optionsComposite;
            {
                this.val$noFillControl = control;
                this.val$colorFillControl = control2;
                this.val$simpleGradientFillControl = control3;
                this.val$advancedGradientFillControl = control4;
                this.val$optionsComposite = composite;
            }

            public void modifyText(ModifyEvent e) {
                if (FXPaintSelectionDialog.this.paint != null) {
                    if (FXPaintSelectionDialog.this.paint instanceof Color && !Color.TRANSPARENT.equals((Object)FXPaintSelectionDialog.this.paint)) {
                        FXPaintSelectionDialog.this.lastFillColor = FXPaintSelectionDialog.this.paint;
                    } else if (FXSimpleLinearGradientPicker.isSimpleLinearGradient((Paint)FXPaintSelectionDialog.this.paint)) {
                        FXPaintSelectionDialog.this.lastSimpleGradient = FXPaintSelectionDialog.this.paint;
                    } else if (FXAdvancedLinearGradientPicker.isAdvancedLinearGradient((Paint)FXPaintSelectionDialog.this.paint)) {
                        FXPaintSelectionDialog.this.lastAdvancedGradient = FXPaintSelectionDialog.this.paint;
                    }
                }
                switch (FXPaintSelectionDialog.this.optionsCombo.getSelectionIndex()) {
                    case 0: {
                        sl.topControl = this.val$noFillControl;
                        FXPaintSelectionDialog.this.paint = (Paint)Color.TRANSPARENT;
                        break;
                    }
                    case 1: {
                        sl.topControl = this.val$colorFillControl;
                        FXPaintSelectionDialog.this.setPaint(FXPaintSelectionDialog.this.lastFillColor);
                        FXPaintSelectionDialog.this.colorPicker.setColor((Color)FXPaintSelectionDialog.this.paint);
                        break;
                    }
                    case 2: {
                        sl.topControl = this.val$simpleGradientFillControl;
                        FXPaintSelectionDialog.this.setPaint(FXPaintSelectionDialog.this.lastSimpleGradient);
                        FXPaintSelectionDialog.this.simpleGradientPicker.setSimpleLinearGradient((LinearGradient)FXPaintSelectionDialog.this.paint);
                        break;
                    }
                    case 3: {
                        sl.topControl = this.val$advancedGradientFillControl;
                        FXPaintSelectionDialog.this.setPaint(FXPaintSelectionDialog.this.lastAdvancedGradient);
                        FXPaintSelectionDialog.this.advancedGradientPicker.setAdvancedGradient((LinearGradient)FXPaintSelectionDialog.this.paint);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported option");
                    }
                }
                FXPaintSelectionDialog.this.updateImageLabel();
                this.val$optionsComposite.layout();
            }
        });
        if (Color.TRANSPARENT.equals((Object)this.paint)) {
            this.optionsCombo.select(0);
        } else if (this.paint instanceof Color) {
            this.optionsCombo.select(1);
        } else if (FXSimpleLinearGradientPicker.isSimpleLinearGradient((Paint)this.paint)) {
            this.optionsCombo.select(2);
        } else if (FXAdvancedLinearGradientPicker.isAdvancedLinearGradient((Paint)this.paint)) {
            this.optionsCombo.select(3);
        } else if (this.paint instanceof ImagePattern) {
            this.optionsCombo.select(4);
        }
        return container;
    }

    protected Control createSimpleGradientFillControl(Composite parent) {
        this.simpleGradientPicker = new FXSimpleLinearGradientPicker(parent, Color.WHITE, Color.BLACK);
        this.simpleGradientPicker.simpleLinearGradientProperty().addListener((ChangeListener)new ChangeListener<LinearGradient>(){

            public void changed(ObservableValue<? extends LinearGradient> observable, LinearGradient oldValue, LinearGradient newValue) {
                FXPaintSelectionDialog.this.setPaint((Paint)newValue);
            }
        });
        return this.simpleGradientPicker;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (this.paint == null) {
            if (paint instanceof Color) {
                if (!Color.TRANSPARENT.equals((Object)paint)) {
                    this.lastFillColor = paint;
                    this.lastSimpleGradient = FXSimpleLinearGradientPicker.createSimpleLinearGradient((Color)Color.WHITE, (Color)((Color)paint));
                    this.lastAdvancedGradient = FXAdvancedLinearGradientPicker.createAdvancedLinearGradient((Color)Color.WHITE, (Color)((Color)paint).brighter(), (Color)((Color)paint));
                }
            } else if (FXSimpleLinearGradientPicker.isSimpleLinearGradient((Paint)paint)) {
                this.lastSimpleGradient = paint;
                List stops = ((LinearGradient)paint).getStops();
                this.lastFillColor = ((Stop)stops.get(1)).getColor();
                this.lastAdvancedGradient = FXAdvancedLinearGradientPicker.createAdvancedLinearGradient((Color)((Stop)stops.get(0)).getColor(), (Color)((Stop)stops.get(1)).getColor().brighter(), (Color)((Stop)stops.get(1)).getColor());
            } else if (FXAdvancedLinearGradientPicker.isAdvancedLinearGradient((Paint)paint)) {
                this.lastAdvancedGradient = paint;
                List stops = paint instanceof LinearGradient ? ((LinearGradient)paint).getStops() : ((RadialGradient)paint).getStops();
                this.lastFillColor = ((Stop)stops.get(stops.size() - 1)).getColor();
                this.lastSimpleGradient = FXSimpleLinearGradientPicker.createSimpleLinearGradient((Color)((Stop)stops.get(0)).getColor(), (Color)((Stop)stops.get(stops.size() - 1)).getColor());
            }
        }
        this.paint = paint;
        this.updateImageLabel();
    }

    protected void updateImageLabel() {
        if (this.optionsCombo != null && this.imageLabel != null && this.paint != null) {
            ImageData imageData = FXPaintUtils.getPaintImageData(64, this.optionsCombo.getItemHeight() - 1, this.paint);
            this.imageLabel.setImage(new Image((Device)this.imageLabel.getDisplay(), imageData, imageData.getTransparencyMask()));
        }
    }
}

