/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.jface;

import javafx.embed.swt.SWTFXUtils;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.fx.swt.controls.FXAdvancedLinearGradientPicker;
import org.eclipse.gef4.fx.swt.controls.FXSimpleLinearGradientPicker;
import org.eclipse.swt.graphics.ImageData;

public class FXPaintUtils {
    public static ImageData getPaintImageData(int width, int height, Paint paint) {
        Canvas canvas = new Canvas((double)width, (double)height);
        GraphicsContext graphicsContext = canvas.getGraphicsContext2D();
        graphicsContext.setFill(paint);
        graphicsContext.fillRect(0.0, 0.0, (double)width, (double)height);
        graphicsContext.setStroke((Paint)Color.BLACK);
        graphicsContext.strokeRect(0.0, 0.0, (double)width, (double)height);
        if (paint instanceof Color && ((Color)paint).getOpacity() == 0.0) {
            graphicsContext.setStroke((Paint)Color.RED);
            graphicsContext.strokeLine(0.0, (double)(height - 1), (double)width, 1.0);
        }
        WritableImage snapshot = canvas.snapshot(new SnapshotParameters(), null);
        return SWTFXUtils.fromFXImage((Image)snapshot, null);
    }

    public static String getPaintDisplayText(Paint paint) {
        if (Color.TRANSPARENT.equals((Object)paint)) {
            return "No Color";
        }
        if (paint instanceof Color) {
            return "Color (" + ((Color)paint).toString() + ")";
        }
        if (FXSimpleLinearGradientPicker.isSimpleLinearGradient((Paint)paint)) {
            return "Gradient " + paint.toString().substring(paint.toString().indexOf("("));
        }
        if (FXAdvancedLinearGradientPicker.isAdvancedLinearGradient((Paint)paint)) {
            return "Advanced Gradient " + paint.toString().substring(paint.toString().indexOf("("));
        }
        return paint.toString();
    }
}

