/*******************************************************************************
 * Copyright (c) 2016 itemis AG and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Matthias Wienand (itemis AG) - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.gef4.mvc.fx.providers;

import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.mvc.parts.IVisualPart;

import javafx.scene.Node;

/**
 * The {@link IAnchorProvider} can provide an {@link IAnchor} for an anchorage
 * part depending on a given anchored {@link IVisualPart} and a corresponding
 * role (see {@link #get(IVisualPart, String)} for details).
 */
public interface IAnchorProvider {

	/**
	 * Returns an {@link IAnchor} that should be used to provide a position for
	 * the given anchored {@link IVisualPart}.
	 *
	 * @param anchoredPart
	 *            The anchored {@link IVisualPart} which the returned
	 *            {@link IAnchor} should provide a position for.
	 * @return An {@link IAnchor} that should be used to provide a position for
	 *         the given anchored {@link IVisualPart}.
	 */
	public IAnchor get(IVisualPart<Node, ? extends Node> anchoredPart);

	/**
	 * Returns an {@link IAnchor} that should be used to provide a position for
	 * the given anchored {@link IVisualPart} and the given role.
	 *
	 * @param anchoredPart
	 *            The anchored {@link IVisualPart} which the returned
	 *            {@link IAnchor} should provide a position for.
	 * @param role
	 *            The role which the returned {@link IAnchor} should provide a
	 *            position for.
	 * @return An {@link IAnchor} that should be used to provide a position for
	 *         the given anchored {@link IVisualPart} and the given role.
	 */
	public IAnchor get(IVisualPart<Node, ? extends Node> anchoredPart,
			String role);

}
