/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.fx.operations.FXChangeViewportOperation;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXChangeViewportPolicy
extends AbstractTransactionPolicy<Node> {
    protected ITransactionalOperation createOperation() {
        FXViewer viewer = (FXViewer)this.getHost().getRoot().getViewer();
        return new FXChangeViewportOperation(viewer.getCanvas(), FX2Geometry.toAffineTransform((Transform)viewer.getCanvas().getContentTransform()));
    }

    protected FXChangeViewportOperation getChangeViewportOperation() {
        return (FXChangeViewportOperation)super.getOperation();
    }

    public void scrollAbsolute(double translateX, double translateY) {
        this.checkInitialized();
        FXChangeViewportOperation operation = this.getChangeViewportOperation();
        operation.setNewHorizontalScrollOffset(operation.getInitialHorizontalScrollOffset() + translateX);
        operation.setNewVerticalScrollOffset(operation.getInitialVerticalScrollOffset() + translateY);
        this.locallyExecuteOperation();
    }

    public void scrollRelative(double deltaTranslateX, double deltaTranslateY) {
        this.checkInitialized();
        FXChangeViewportOperation operation = this.getChangeViewportOperation();
        operation.setNewHorizontalScrollOffset(operation.getNewHorizontalScrollOffset() + deltaTranslateX);
        operation.setNewVerticalScrollOffset(operation.getNewVerticalScrollOffset() + deltaTranslateY);
        this.locallyExecuteOperation();
    }

    public void zoomAbsolute(double relativeZoom, double sceneX, double sceneY) {
        this.checkInitialized();
        Point2D contentGroupPivot = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(sceneX, sceneY);
        AffineTransform zoomTx = new AffineTransform().translate(contentGroupPivot.getX(), contentGroupPivot.getY()).scale(relativeZoom, relativeZoom).translate(-contentGroupPivot.getX(), -contentGroupPivot.getY());
        AffineTransform newTx = this.getChangeViewportOperation().getInitialContentTransform().getCopy().concatenate(zoomTx);
        this.getChangeViewportOperation().setNewContentTransform(newTx);
        this.locallyExecuteOperation();
    }

    public void zoomRelative(double relativeZoom, double sceneX, double sceneY) {
        this.checkInitialized();
        Point2D contentGroupPivot = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas().getContentGroup().sceneToLocal(sceneX, sceneY);
        this.getChangeViewportOperation().concatenateToNewContentTransform(new AffineTransform().translate(contentGroupPivot.getX(), contentGroupPivot.getY()).scale(relativeZoom, relativeZoom).translate(-contentGroupPivot.getX(), -contentGroupPivot.getY()));
        this.locallyExecuteOperation();
    }
}

