/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnTypePolicy;
import org.eclipse.gef4.mvc.fx.tools.FXClickDragTool;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.DeletionPolicy;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXDeleteSelectedOnTypePolicy
extends AbstractFXInteractionPolicy
implements IFXOnTypePolicy {
    protected boolean isDelete(KeyEvent event) {
        if (event.getCode() != KeyCode.DELETE) {
            return false;
        }
        FXClickDragTool tool = (FXClickDragTool)((Object)this.getHost().getRoot().getViewer().getDomain().getAdapter(FXClickDragTool.class));
        return tool == null || !this.getHost().getRoot().getViewer().getDomain().isExecutionTransactionOpen((ITool)tool);
    }

    @Override
    public void pressed(KeyEvent event) {
        if (!this.isDelete(event)) {
            return;
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ArrayList selected = new ArrayList(((SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable());
        if (selected.isEmpty()) {
            return;
        }
        DeletionPolicy deletionPolicy = (DeletionPolicy)this.getHost().getRoot().getAdapter((TypeToken)new TypeToken<DeletionPolicy<Node>>(){});
        this.init((AbstractTransactionPolicy)deletionPolicy);
        for (IContentPart s : selected) {
            deletionPolicy.delete(s);
        }
        this.commit((AbstractTransactionPolicy)deletionPolicy);
    }

    @Override
    public void released(KeyEvent event) {
    }

    @Override
    public void typed(KeyEvent event) {
    }

    @Override
    public void unfocus() {
    }
}

