/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.scene.Node;
import javafx.scene.input.ZoomEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.mvc.fx.policies.FXChangeViewportPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnPinchSpreadPolicy;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.policies.AbstractInteractionPolicy;

public class FXZoomOnPinchSpreadPolicy
extends AbstractInteractionPolicy<Node>
implements IFXOnPinchSpreadPolicy {
    private boolean invalidGesture = false;
    private FXChangeViewportPolicy viewportPolicy;

    protected FXChangeViewportPolicy determineViewportPolicy() {
        return (FXChangeViewportPolicy)((Object)this.getHost().getRoot().getAdapter(FXChangeViewportPolicy.class));
    }

    protected FXChangeViewportPolicy getViewportPolicy() {
        return this.viewportPolicy;
    }

    protected boolean isZoom(ZoomEvent e) {
        return true;
    }

    @Override
    public void zoom(ZoomEvent e) {
        if (this.invalidGesture) {
            return;
        }
        this.getViewportPolicy().zoomRelative(e.getZoomFactor(), e.getSceneX(), e.getSceneY());
    }

    @Override
    public void zoomAborted() {
    }

    @Override
    public void zoomFinished(ZoomEvent event) {
        if (this.invalidGesture) {
            return;
        }
        ITransactionalOperation commit = this.getViewportPolicy().commit();
        if (commit != null && !commit.isNoOp()) {
            try {
                this.getHost().getRoot().getViewer().getDomain().execute(commit);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void zoomStarted(ZoomEvent e) {
        boolean bl = this.invalidGesture = !this.isZoom(e);
        if (this.invalidGesture) {
            return;
        }
        this.viewportPolicy = this.determineViewportPolicy();
        this.viewportPolicy.init();
    }
}

