/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.fx.gestures.AbstractMouseDragGesture;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.policies.IPolicy;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXClickDragTool
extends AbstractTool<Node> {
    public static final Class<IFXOnClickPolicy> ON_CLICK_POLICY_KEY = IFXOnClickPolicy.class;
    public static final Class<IFXOnDragPolicy> ON_DRAG_POLICY_KEY = IFXOnDragPolicy.class;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;
    private final Map<Scene, AbstractMouseDragGesture> gestures = new HashMap<Scene, AbstractMouseDragGesture>();
    private final Map<IViewer<Node>, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer<Node>, ChangeListener<Boolean>>();
    private final Map<Scene, EventHandler<MouseEvent>> cursorMouseMoveFilters = new HashMap<Scene, EventHandler<MouseEvent>>();
    private final Map<Scene, EventHandler<KeyEvent>> cursorKeyFilters = new HashMap<Scene, EventHandler<KeyEvent>>();
    private IViewer<Node> activeViewer;

    public List<IFXOnDragPolicy> getActivePolicies(IViewer<Node> viewer) {
        return super.getActivePolicies(viewer);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (FXClickDragTool.this.activeViewer == null) {
                        return;
                    }
                    for (IViewer iViewer : FXClickDragTool.this.getDomain().getViewers().values()) {
                        if (!iViewer.isViewerFocused()) continue;
                        return;
                    }
                    for (IPolicy iPolicy : FXClickDragTool.this.getActivePolicies((IViewer<Node>)FXClickDragTool.this.activeViewer)) {
                        if (!(iPolicy instanceof IFXOnDragPolicy)) continue;
                        ((IFXOnDragPolicy)iPolicy).dragAborted();
                    }
                    FXClickDragTool.this.clearActivePolicies(FXClickDragTool.this.activeViewer);
                    FXClickDragTool.this.activeViewer = null;
                    FXClickDragTool.this.getDomain().closeExecutionTransaction((ITool)FXClickDragTool.this);
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put((IViewer<Node>)viewer, viewerFocusChangeListener);
            Scene scene = ((FXViewer)viewer).getScene();
            if (this.gestures.containsKey(scene)) continue;
            final IFXOnDragPolicy[] indicationCursorPolicy = new IFXOnDragPolicy[1];
            final List[] possibleDragPolicies = new ArrayList[1];
            EventHandler<MouseEvent> indicationCursorMouseMoveFilter = new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    EventTarget eventTarget;
                    if (indicationCursorPolicy[0] != null) {
                        indicationCursorPolicy[0].hideIndicationCursor();
                        indicationCursorPolicy[0] = null;
                    }
                    if ((eventTarget = event.getTarget()) instanceof Node) {
                        Node target = (Node)eventTarget;
                        possibleDragPolicies[0] = new ArrayList<IFXOnDragPolicy>(FXClickDragTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXClickDragTool.this, target, ON_DRAG_POLICY_KEY));
                        ListIterator dragIterator = possibleDragPolicies[0].listIterator(possibleDragPolicies[0].size());
                        while (dragIterator.hasPrevious()) {
                            IFXOnDragPolicy policy = (IFXOnDragPolicy)dragIterator.previous();
                            if (!policy.showIndicationCursor(event)) continue;
                            indicationCursorPolicy[0] = policy;
                            break;
                        }
                    }
                }
            };
            scene.addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)indicationCursorMouseMoveFilter);
            this.cursorMouseMoveFilters.put(scene, indicationCursorMouseMoveFilter);
            EventHandler<KeyEvent> indicationCursorKeyFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (indicationCursorPolicy[0] != null) {
                        indicationCursorPolicy[0].hideIndicationCursor();
                        indicationCursorPolicy[0] = null;
                    }
                    if (possibleDragPolicies[0] == null || possibleDragPolicies[0].isEmpty()) {
                        return;
                    }
                    ListIterator dragIterator = possibleDragPolicies[0].listIterator(possibleDragPolicies[0].size());
                    while (dragIterator.hasPrevious()) {
                        IFXOnDragPolicy policy = (IFXOnDragPolicy)dragIterator.previous();
                        if (!policy.showIndicationCursor(event)) continue;
                        indicationCursorPolicy[0] = policy;
                        break;
                    }
                }
            };
            scene.addEventFilter(KeyEvent.ANY, (EventHandler)indicationCursorKeyFilter);
            this.cursorKeyFilters.put(scene, indicationCursorKeyFilter);
            AbstractMouseDragGesture gesture = new AbstractMouseDragGesture((EventHandler)indicationCursorMouseMoveFilter, (EventHandler)indicationCursorKeyFilter, indicationCursorPolicy){
                private final /* synthetic */ EventHandler val$indicationCursorMouseMoveFilter;
                private final /* synthetic */ EventHandler val$indicationCursorKeyFilter;
                private final /* synthetic */ IFXOnDragPolicy[] val$indicationCursorPolicy;
                {
                    this.val$indicationCursorMouseMoveFilter = eventHandler;
                    this.val$indicationCursorKeyFilter = eventHandler2;
                    this.val$indicationCursorPolicy = iFXOnDragPolicyArray;
                }

                protected void drag(Node target, MouseEvent e, double dx, double dy) {
                    if (FXClickDragTool.this.getActivePolicies((IViewer<Node>)FXClickDragTool.this.activeViewer).isEmpty()) {
                        return;
                    }
                    for (IFXOnDragPolicy policy : FXClickDragTool.this.getActivePolicies((IViewer<Node>)FXClickDragTool.this.activeViewer)) {
                        policy.drag(e, new Dimension(dx, dy));
                    }
                }

                protected void press(Node target, MouseEvent e) {
                    if (viewer instanceof FXViewer) {
                        InfiniteCanvas canvas = ((FXViewer)viewer).getCanvas();
                        if (e.getTarget() instanceof Node) {
                            Node targetNode = (Node)e.getTarget();
                            while (targetNode != null) {
                                if (targetNode == canvas.getHorizontalScrollBar() || targetNode == canvas.getVerticalScrollBar()) {
                                    return;
                                }
                                targetNode = targetNode.getParent();
                            }
                        }
                    }
                    this.val$indicationCursorMouseMoveFilter.handle((Event)e);
                    Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
                    scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.val$indicationCursorMouseMoveFilter);
                    scene.removeEventFilter(KeyEvent.ANY, this.val$indicationCursorKeyFilter);
                    boolean opened = false;
                    List<IFXOnClickPolicy> clickPolicies = FXClickDragTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXClickDragTool.this, target, ON_CLICK_POLICY_KEY);
                    if (clickPolicies != null && !clickPolicies.isEmpty()) {
                        opened = true;
                        FXClickDragTool.this.getDomain().openExecutionTransaction((ITool)FXClickDragTool.this);
                        for (IFXOnClickPolicy clickPolicy : clickPolicies) {
                            clickPolicy.click(e);
                        }
                    }
                    FXClickDragTool.this.activeViewer = FXPartUtils.retrieveViewer((IDomain<Node>)FXClickDragTool.this.getDomain(), target);
                    List<IFXOnDragPolicy> policies = null;
                    if (FXClickDragTool.this.activeViewer != null) {
                        policies = FXClickDragTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXClickDragTool.this, target, (IViewer<Node>)FXClickDragTool.this.activeViewer, ON_DRAG_POLICY_KEY);
                    }
                    if (policies == null || policies.isEmpty()) {
                        if (opened) {
                            FXClickDragTool.this.getDomain().closeExecutionTransaction((ITool)FXClickDragTool.this);
                        }
                        policies = null;
                        return;
                    }
                    if (!opened) {
                        FXClickDragTool.this.getDomain().openExecutionTransaction((ITool)FXClickDragTool.this);
                    }
                    FXClickDragTool.this.setActivePolicies(FXClickDragTool.this.activeViewer, policies);
                    for (IFXOnDragPolicy policy : policies) {
                        policy.press(e);
                    }
                }

                protected void release(Node target, MouseEvent e, double dx, double dy) {
                    Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
                    scene.addEventFilter(MouseEvent.MOUSE_MOVED, this.val$indicationCursorMouseMoveFilter);
                    scene.addEventFilter(KeyEvent.ANY, this.val$indicationCursorKeyFilter);
                    if (FXClickDragTool.this.getActivePolicies((IViewer<Node>)FXClickDragTool.this.activeViewer).isEmpty()) {
                        FXClickDragTool.this.activeViewer = null;
                        return;
                    }
                    for (IFXOnDragPolicy policy : FXClickDragTool.this.getActivePolicies((IViewer<Node>)FXClickDragTool.this.activeViewer)) {
                        policy.release(e, new Dimension(dx, dy));
                    }
                    FXClickDragTool.this.clearActivePolicies(FXClickDragTool.this.activeViewer);
                    FXClickDragTool.this.activeViewer = null;
                    FXClickDragTool.this.getDomain().closeExecutionTransaction((ITool)FXClickDragTool.this);
                    if (this.val$indicationCursorPolicy[0] != null) {
                        this.val$indicationCursorPolicy[0].hideIndicationCursor();
                        this.val$indicationCursorPolicy[0] = null;
                    }
                }
            };
            gesture.setScene(scene);
            this.gestures.put(scene, gesture);
        }
    }

    protected void unregisterListeners() {
        for (Scene scene : new ArrayList<Scene>(this.gestures.keySet())) {
            this.gestures.remove(scene).setScene(null);
            scene.removeEventFilter(MouseEvent.MOUSE_MOVED, this.cursorMouseMoveFilters.remove(scene));
            scene.removeEventFilter(KeyEvent.ANY, this.cursorKeyFilters.remove(scene));
        }
        for (IViewer iViewer : new ArrayList<IViewer<Node>>(this.viewerFocusChangeListeners.keySet())) {
            iViewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(iViewer));
        }
        super.unregisterListeners();
    }
}

