/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.viewer;

import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Window;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.AbstractViewer;

public class FXViewer
extends AbstractViewer<Node> {
    public static final String DEFAULT_STYLE = "-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0);";
    public static final String FOCUSED_STYLE = "-fx-background-insets: 0; -fx-padding: 0; -fx-background-color: rgba(0,0,0,0); -fx-border-color: #8ec0fc; -fx-border-width: 2;";
    protected InfiniteCanvas infiniteCanvas;
    private boolean isInitialized = false;
    private boolean isWindowFocused = false;
    private boolean isFocusOwnerFocused = false;
    private ReadOnlyBooleanWrapper viewerFocusedProperty = new ReadOnlyBooleanWrapper(false);
    private BooleanBinding viewerFocusedPropertyBinding = new BooleanBinding(){

        protected boolean computeValue() {
            return FXViewer.this.isWindowFocused && FXViewer.this.isFocusOwnerFocused;
        }
    };
    private ChangeListener<Window> windowObserver = new ChangeListener<Window>(){

        public void changed(ObservableValue<? extends Window> observable, Window oldValue, Window newValue) {
            FXViewer.this.onWindowChanged(oldValue, newValue);
        }
    };
    private ChangeListener<Boolean> windowFocusedObserver = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            FXViewer.this.onWindowFocusedChanged(oldValue, newValue);
        }
    };
    private ChangeListener<Node> focusOwnerObserver = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
            if (oldValue != newValue) {
                FXViewer.this.onFocusOwnerChanged(oldValue, newValue);
            }
        }
    };
    private ChangeListener<Boolean> focusOwnerFocusedObserver = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            if (observable == FXViewer.this.getCanvas().getScene().getFocusOwner() && (oldValue == null ? newValue != null : !oldValue.equals(newValue))) {
                FXViewer.this.onFocusOwnerFocusedChanged(oldValue, newValue);
            }
        }
    };

    public FXViewer() {
        this.viewerFocusedProperty.bind((ObservableValue)this.viewerFocusedPropertyBinding);
    }

    public InfiniteCanvas getCanvas() {
        IRootPart rootPart;
        if (this.infiniteCanvas == null && (rootPart = this.getRootPart()) != null) {
            this.infiniteCanvas = new InfiniteCanvas();
            this.infiniteCanvas.setStyle(DEFAULT_STYLE);
            this.infiniteCanvas.getContentGroup().getChildren().addAll((Object[])new Node[]{(Parent)rootPart.getVisual()});
            this.infiniteCanvas.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

                public void changed(ObservableValue<? extends Scene> observable, Scene oldValue, Scene newValue) {
                    FXViewer.this.onSceneChanged(oldValue, newValue);
                }
            });
            if (this.infiniteCanvas.getScene() != null) {
                this.onSceneChanged(null, this.infiniteCanvas.getScene());
            }
        }
        return this.infiniteCanvas;
    }

    public FXDomain getDomain() {
        return (FXDomain)super.getDomain();
    }

    public Scene getScene() {
        return this.infiniteCanvas.getScene();
    }

    public boolean isViewerFocused() {
        return this.viewerFocusedProperty.get();
    }

    public boolean isViewerVisual(Node node) {
        while (node != null) {
            if (node == this.infiniteCanvas) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    private void onFocusOwnerChanged(Node oldFocusOwner, Node newFocusOwner) {
        if (oldFocusOwner != null && this.isViewerVisual(oldFocusOwner)) {
            oldFocusOwner.focusedProperty().removeListener(this.focusOwnerFocusedObserver);
        }
        if (newFocusOwner != null && this.isViewerVisual(newFocusOwner)) {
            newFocusOwner.focusedProperty().addListener(this.focusOwnerFocusedObserver);
            if (Boolean.TRUE.equals(newFocusOwner.focusedProperty().get())) {
                this.isFocusOwnerFocused = true;
                this.viewerFocusedPropertyBinding.invalidate();
            }
        } else {
            this.isFocusOwnerFocused = false;
            this.viewerFocusedPropertyBinding.invalidate();
        }
    }

    private void onFocusOwnerFocusedChanged(Boolean oldValue, Boolean newValue) {
        this.isFocusOwnerFocused = Boolean.TRUE.equals(newValue);
        this.viewerFocusedPropertyBinding.invalidate();
    }

    private void onSceneChanged(Scene oldScene, Scene newScene) {
        Window oldWindow = null;
        Window newWindow = null;
        Node oldFocusOwner = null;
        Node newFocusOwner = null;
        if (oldScene != null) {
            oldWindow = (Window)oldScene.windowProperty().get();
            oldScene.windowProperty().removeListener(this.windowObserver);
            oldFocusOwner = (Node)oldScene.focusOwnerProperty().get();
            oldScene.focusOwnerProperty().removeListener(this.focusOwnerObserver);
        }
        if (newScene != null) {
            newWindow = (Window)newScene.windowProperty().get();
            newScene.windowProperty().addListener(this.windowObserver);
            newFocusOwner = (Node)newScene.focusOwnerProperty().get();
            newScene.focusOwnerProperty().addListener(this.focusOwnerObserver);
        }
        this.onWindowChanged(oldWindow, newWindow);
        this.onFocusOwnerChanged(oldFocusOwner, newFocusOwner);
    }

    private void onWindowChanged(Window oldValue, Window newValue) {
        if (oldValue != null) {
            oldValue.focusedProperty().removeListener(this.windowFocusedObserver);
        }
        if (newValue != null) {
            newValue.focusedProperty().addListener(this.windowFocusedObserver);
            if (Boolean.TRUE.equals(newValue.focusedProperty().get())) {
                this.isWindowFocused = true;
                this.viewerFocusedPropertyBinding.invalidate();
            }
        } else {
            this.isInitialized = false;
            this.isWindowFocused = false;
            this.viewerFocusedPropertyBinding.invalidate();
        }
    }

    private void onWindowFocusedChanged(Boolean oldValue, Boolean newValue) {
        this.isWindowFocused = Boolean.TRUE.equals(newValue);
        this.viewerFocusedPropertyBinding.invalidate();
        if (!this.isInitialized) {
            ((Node)this.getRootPart().getVisual()).requestFocus();
            this.isInitialized = true;
        }
    }

    public void reveal(IVisualPart<Node, ? extends Node> visualPart) {
        if (visualPart == null) {
            this.getCanvas().setHorizontalScrollOffset(0.0);
            this.getCanvas().setVerticalScrollOffset(0.0);
        } else {
            this.getCanvas().reveal((Node)visualPart.getVisual());
        }
    }

    public ReadOnlyBooleanProperty viewerFocusedProperty() {
        return this.viewerFocusedProperty.getReadOnlyProperty();
    }
}

