/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.ui.properties;

import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.ui.Messages;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class SetPropertyValueOperation
extends AbstractOperation
implements ITransactionalOperation {
    protected static final Object DEFAULT_VALUE = new Object();
    private Object newValue;
    private Object oldValue;
    private Object propertyId;
    private IPropertySource propertySource;

    private static IPropertyDescriptor getPropertyDescriptor(IPropertySource propertySource, Object propertyId) {
        IPropertyDescriptor[] iPropertyDescriptorArray = propertySource.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor propertyDescriptor = iPropertyDescriptorArray[n2];
            if (propertyDescriptor.getId().equals(propertyId)) {
                return propertyDescriptor;
            }
            ++n2;
        }
        return null;
    }

    private static String getValueLabel(IPropertySource propertySource, Object propertyId, Object newValue) {
        IPropertyDescriptor propertyDescriptor = SetPropertyValueOperation.getPropertyDescriptor(propertySource, propertyId);
        return propertyDescriptor.getLabelProvider().getText(newValue);
    }

    public SetPropertyValueOperation(String propertyLabel, IPropertySource propertySource, Object propertyId, Object newValue) {
        super(MessageFormat.format(Messages.SetPropertyValueCommand_Label, propertyLabel, SetPropertyValueOperation.getValueLabel(propertySource, propertyId, newValue)).trim());
        this.propertySource = propertySource;
        this.propertyId = propertyId;
        this.newValue = newValue;
    }

    public boolean canExecute() {
        if (this.propertySource == null || this.propertyId == null) {
            return false;
        }
        if (this.newValue == DEFAULT_VALUE) {
            boolean canExecute = this.propertySource.isPropertySet(this.propertyId);
            if (this.propertySource instanceof IPropertySource2) {
                canExecute &= ((IPropertySource2)this.propertySource).isPropertyResettable(this.propertyId);
            }
            return canExecute;
        }
        return true;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        boolean wasPropertySet = this.propertySource.isPropertySet(this.propertyId);
        this.oldValue = this.unwrapValue(this.propertySource.getPropertyValue(this.propertyId));
        if (this.newValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, this.unwrapValue(this.newValue));
        }
        if (this.propertySource instanceof IPropertySource2) {
            if (!wasPropertySet && ((IPropertySource2)this.propertySource).isPropertyResettable(this.propertyId)) {
                this.oldValue = DEFAULT_VALUE;
            }
        } else if (!wasPropertySet && this.propertySource.isPropertySet(this.propertyId)) {
            this.oldValue = DEFAULT_VALUE;
        }
        return Status.OK_STATUS;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public Object getPropertyId() {
        return this.propertyId;
    }

    public IPropertySource getPropertySource() {
        return this.propertySource;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        return this.oldValue == this.newValue || this.oldValue != null && this.oldValue.equals(this.newValue);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.oldValue == DEFAULT_VALUE) {
            this.propertySource.resetPropertyValue(this.propertyId);
        } else {
            this.propertySource.setPropertyValue(this.propertyId, this.oldValue);
        }
        return Status.OK_STATUS;
    }

    private Object unwrapValue(Object value) {
        if (value instanceof IPropertySource) {
            return ((IPropertySource)value).getEditableValue();
        }
        return value;
    }
}

