/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;

public class RemoveContentChildOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    private final IContentPart<VR, ? extends VR> parent;
    private final Object contentChild;
    private List<Object> initialContentChildren;
    private int initialIndex;

    public RemoveContentChildOperation(IContentPart<VR, ? extends VR> parent, Object contentChild) {
        super("Remove Content Child");
        this.parent = parent;
        this.contentChild = contentChild;
        this.initialIndex = parent.getContentChildrenUnmodifiable().indexOf(contentChild);
        this.initialContentChildren = ImmutableList.copyOf(parent.getContentChildrenUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.parent.getContent() != null && this.parent.getContentChildrenUnmodifiable().contains(this.contentChild)) {
            this.parent.removeContentChild(this.contentChild);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return !this.initialContentChildren.contains(this.contentChild);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.parent.getContentChildrenUnmodifiable().contains(this.contentChild)) {
            this.parent.addContentChild(this.contentChild, this.initialIndex);
        }
        return Status.OK_STATUS;
    }
}

