/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;

public class TransformContentOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    private final ITransformableContentPart<VR, ? extends VR> transformableContentPart;
    private AffineTransform finalDelta;
    private AffineTransform currentDelta;

    public TransformContentOperation(ITransformableContentPart<VR, ? extends VR> transformableContentPart, AffineTransform deltaTransform) {
        super("Transform Content");
        this.transformableContentPart = transformableContentPart;
        this.currentDelta = new AffineTransform();
        this.finalDelta = deltaTransform;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        AffineTransform delta = this.currentDelta.getInverse().preConcatenate(this.finalDelta);
        this.currentDelta = this.finalDelta;
        if (!delta.isIdentity()) {
            this.transformableContentPart.transformContent(delta);
        }
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.finalDelta.isIdentity();
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public void setFinalDelta(AffineTransform transform) {
        this.finalDelta = transform;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.currentDelta.isIdentity()) {
            this.transformableContentPart.transformContent(this.currentDelta.getInverse());
        }
        this.currentDelta = new AffineTransform();
        return Status.OK_STATUS;
    }
}

