/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.mvc.behaviors.IBehavior;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultHoverHandlePartFactory;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.parts.HideHoverHandlePart;
import org.eclipse.gef4.zest.fx.parts.NodePart;
import org.eclipse.gef4.zest.fx.parts.ShowHiddenNeighborsHoverHandlePart;

public class ZestFxHoverHandlePartFactory
extends FXDefaultHoverHandlePartFactory {
    @Inject
    private Injector injector;

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandlePartsForPolygonalOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        ArrayList<IHandlePart<Node, ? extends Node>> handleParts = new ArrayList<IHandlePart<Node, ? extends Node>>();
        if (target instanceof NodePart) {
            HideHoverHandlePart hidePart = (HideHoverHandlePart)((Object)this.injector.getInstance(HideHoverHandlePart.class));
            hidePart.setSegmentsProvider(segmentsProvider);
            hidePart.setSegmentIndex(0);
            hidePart.setSegmentParameter(0.0);
            handleParts.add((IHandlePart<Node, ? extends Node>)hidePart);
            HidingModel hidingModel = (HidingModel)target.getRoot().getViewer().getAdapter(HidingModel.class);
            if (hidingModel.hasHiddenNeighbors((NodePart)target)) {
                ShowHiddenNeighborsHoverHandlePart showPart = (ShowHiddenNeighborsHoverHandlePart)((Object)this.injector.getInstance(ShowHiddenNeighborsHoverHandlePart.class));
                showPart.setSegmentsProvider(segmentsProvider);
                showPart.setSegmentIndex(1);
                showPart.setSegmentParameter(0.0);
                handleParts.add((IHandlePart<Node, ? extends Node>)showPart);
            }
        }
        return handleParts;
    }

    protected List<IHandlePart<Node, ? extends Node>> createHoverHandlePartsForRectangularOutline(IVisualPart<Node, ? extends Node> target, IBehavior<Node> contextBehavior, Map<Object, Object> contextMap, Provider<BezierCurve[]> segmentsProvider) {
        return this.createHoverHandlePartsForPolygonalOutline(target, contextBehavior, contextMap, segmentsProvider);
    }
}

