/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.logicdesigner.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.examples.logicdesigner.LogicMessages;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public abstract class PasteTemplateAction
extends SelectionAction {
    public PasteTemplateAction(IWorkbenchPart editor) {
        super(editor);
    }

    protected boolean calculateEnabled() {
        return true;
    }

    protected Command createPasteCommand() {
        Object obj;
        Command result = null;
        List selection = this.getSelectedObjects();
        if (selection != null && selection.size() == 1 && (obj = selection.get(0)) instanceof GraphicalEditPart) {
            CreationFactory factory;
            GraphicalEditPart gep = (GraphicalEditPart)obj;
            Object template = this.getClipboardContents();
            if (template != null && (factory = this.getFactory(template)) != null) {
                CreateRequest request = new CreateRequest();
                request.setFactory(factory);
                request.setLocation(this.getPasteLocation(gep));
                result = gep.getCommand((Request)request);
            }
        }
        return result;
    }

    protected Object getClipboardContents() {
        return Clipboard.getDefault().getContents();
    }

    protected abstract CreationFactory getFactory(Object var1);

    protected abstract Point getPasteLocation(GraphicalEditPart var1);

    protected void init() {
        this.setId(ActionFactory.PASTE.getId());
        this.setText(LogicMessages.PasteAction_ActionLabelText);
    }

    public void run() {
        this.execute(this.createPasteCommand());
    }
}

