/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.UpdateListener;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;

public class GraphicalTextViewer
extends ScrollingGraphicalViewer {
    private Caret caret;
    private Runnable caretRefresh;
    private SelectionRange selectionRange;

    private Caret getCaret() {
        if (this.caret == null && this.getControl() != null) {
            this.caret = new Caret((Canvas)this.getControl(), 0);
        }
        return this.caret;
    }

    public Rectangle getCaretBounds() {
        return new Rectangle(this.getCaret().getBounds());
    }

    public TextLocation getCaretLocation() {
        if (this.selectionRange.isForward) {
            return this.selectionRange.end;
        }
        return this.selectionRange.begin;
    }

    public TextualEditPart getCaretOwner() {
        if (this.selectionRange == null) {
            return null;
        }
        if (this.selectionRange.isForward) {
            return this.selectionRange.end.part;
        }
        return this.selectionRange.begin.part;
    }

    public SelectionRange getSelectionRange() {
        return this.selectionRange;
    }

    private UpdateManager getUpdateManager() {
        return this.getLightweightSystem().getUpdateManager();
    }

    protected void hookControl() {
        super.hookControl();
        this.getUpdateManager().addUpdateListener(new UpdateListener(){

            public void notifyPainting(Rectangle damage, Map dirtyRegions) {
            }

            public void notifyValidating() {
                GraphicalTextViewer.this.queueCaretRefresh();
            }
        });
    }

    void queueCaretRefresh() {
        if (this.caretRefresh == null) {
            this.caretRefresh = new CaretRefresh();
            this.getUpdateManager().runWithUpdate(this.caretRefresh);
        }
    }

    void refreshCaret() {
        if (this.getCaretOwner() == null) {
            return;
        }
        TextLocation location = this.getCaretLocation();
        CaretInfo info = this.getSelectionRange().isForward && location.offset > 0 ? this.getCaretOwner().getCaretPlacement(location.offset - 1, true) : this.getCaretOwner().getCaretPlacement(location.offset, false);
        this.getCaret().setBounds(info.getX(), info.getY(), 1, info.getHeight());
    }

    public void setCaretVisible(boolean value) {
        Assert.isNotNull((Object)this.getControl(), (String)"The control has not been created");
        this.getCaret().setVisible(value);
    }

    public void setSelectionRange(SelectionRange newRange) {
        int i;
        List currentSelection;
        if (this.selectionRange != null) {
            currentSelection = this.selectionRange.getSelectedParts();
            i = 0;
            while (i < currentSelection.size()) {
                ((TextualEditPart)currentSelection.get(i)).setSelection(-1, -1);
                ++i;
            }
        }
        this.selectionRange = newRange;
        if (this.selectionRange != null) {
            currentSelection = this.selectionRange.getSelectedParts();
            i = 0;
            while (i < currentSelection.size()) {
                TextualEditPart textpart = (TextualEditPart)currentSelection.get(i);
                textpart.setSelection(0, textpart.getLength());
                ++i;
            }
            if (this.selectionRange.begin.part == this.selectionRange.end.part) {
                this.selectionRange.begin.part.setSelection(this.selectionRange.begin.offset, this.selectionRange.end.offset);
            } else {
                this.selectionRange.begin.part.setSelection(this.selectionRange.begin.offset, this.selectionRange.begin.part.getLength());
                this.selectionRange.end.part.setSelection(0, this.selectionRange.end.offset);
            }
        }
        this.queueCaretRefresh();
        this.fireSelectionChanged();
    }

    class CaretRefresh
    implements Runnable {
        CaretRefresh() {
        }

        public void run() {
            GraphicalTextViewer.this.refreshCaret();
            GraphicalTextViewer.this.caretRefresh = null;
        }
    }
}

