/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.edit;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.CaretInfo;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.gef.examples.text.TextLocation;
import org.eclipse.gef.examples.text.edit.AbstractTextualPart;
import org.eclipse.gef.examples.text.edit.BlockTextualPart;
import org.eclipse.gef.examples.text.edit.CaretSearch;
import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.examples.text.figures.CommentPage;
import org.eclipse.gef.examples.text.model.Container;

public abstract class CompoundTextualPart
extends AbstractTextualPart {
    public CompoundTextualPart(Object model) {
        this.setModel(model);
    }

    public boolean acceptsCaret() {
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            Object part = iter.next();
            if (!(part instanceof TextualEditPart) || !((TextualEditPart)part).acceptsCaret()) continue;
            return true;
        }
        return false;
    }

    public void activate() {
        super.activate();
        this.getContainer().getStyle().addPropertyChangeListener(this);
    }

    protected void createEditPolicies() {
    }

    protected IFigure createFigure() {
        Object figure = null;
        switch (this.getContainer().getType()) {
            case 6: {
                figure = new InlineFlow();
                break;
            }
            case 2: {
                figure = new CommentPage();
                break;
            }
            case 4: {
                figure = new BlockFlow();
                figure.setBorder((Border)new MarginBorder(4, 2, 4, 0));
                break;
            }
            case 5: {
                figure = new FlowPage();
                figure.setBorder((Border)new MarginBorder(4));
                break;
            }
            default: {
                System.out.println("unexpected");
            }
        }
        return figure;
    }

    public void deactivate() {
        this.getContainer().getStyle().removePropertyChangeListener(this);
        super.deactivate();
    }

    public CaretInfo getCaretPlacement(int offset, boolean trailing) {
        throw new RuntimeException("This part cannot place the caret");
    }

    protected Container getContainer() {
        return (Container)this.getModel();
    }

    public int getLength() {
        return this.getChildren().size();
    }

    public TextLocation getLocation(Point absolute, int[] trailing) {
        TextLocation result = null;
        int dx = Integer.MAX_VALUE;
        int dy = Integer.MAX_VALUE;
        int[] isAfter = new int[1];
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            TextLocation location;
            Object part = iter.next();
            if (!(part instanceof TextualEditPart) || (location = ((TextualEditPart)part).getLocation(absolute, isAfter)) == null) continue;
            CaretInfo caretInfo = location.part.getCaretPlacement(location.offset, isAfter[0] == 1);
            int yDistance = this.vDistanceBetween(caretInfo, absolute.y);
            int xDistance = Math.abs(caretInfo.getX() - absolute.x);
            if (yDistance >= dy && (yDistance != dy || xDistance >= dx)) continue;
            result = location;
            trailing[0] = isAfter[0];
            dx = xDistance;
            dy = yDistance;
        }
        return result;
    }

    protected List getModelChildren() {
        return this.getContainer().getChildren();
    }

    public TextLocation getNextLocation(CaretSearch search) {
        switch (search.type) {
            case 4: {
                if (search.isForward) {
                    return this.searchLineEnd(search);
                }
                return this.searchLineBegin(search);
            }
            case 2: {
                if (search.isForward) {
                    return this.searchLineBelow(search);
                }
                return this.searchLineAbove(search);
            }
            case 3: {
                return null;
            }
            case 1: {
                if (search.isForward) {
                    return this.searchForward(search);
                }
                return this.searchBackwards(search);
            }
        }
        if (this.getParent() instanceof TextualEditPart) {
            return this.getTextParent().getNextLocation(search);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("children")) {
            this.refreshChildren();
        }
    }

    TextLocation searchBackwards(CaretSearch search) {
        TextLocation location = search.where;
        int childIndex = location == null ? this.getChildren().size() - 1 : this.getChildren().indexOf(location.part) - 1;
        while (childIndex >= 0) {
            TextualEditPart part = (TextualEditPart)this.getChildren().get(childIndex--);
            location = part.getNextLocation(search.recurseSearch());
            if (location == null) continue;
            return location;
        }
        if (search.isRecursive) {
            return null;
        }
        if (this.getParent() instanceof TextualEditPart) {
            return this.getTextParent().getNextLocation(search.continueSearch(this, 0));
        }
        return null;
    }

    TextLocation searchForward(CaretSearch search) {
        TextLocation location = search.where;
        int childIndex = location == null ? 0 : this.getChildren().indexOf(location.part) + 1;
        int childCount = this.getChildren().size();
        CaretSearch recurse = search.recurseSearch();
        while (childIndex < childCount) {
            TextualEditPart part = (TextualEditPart)this.getChildren().get(childIndex++);
            location = part.getNextLocation(recurse);
            if (location == null) continue;
            return location;
        }
        if (search.isRecursive) {
            return null;
        }
        if (this instanceof BlockTextualPart) {
            search.isInto = true;
        }
        if (this.getParent() instanceof TextualEditPart) {
            return this.getTextParent().getNextLocation(search.continueSearch(this, this.getLength()));
        }
        return null;
    }

    protected TextLocation searchLineAbove(CaretSearch search) {
        int childIndex;
        TextLocation location = search.where;
        if (location == null) {
            childIndex = this.getChildren().size() - 1;
        } else {
            childIndex = this.getChildren().indexOf(location.part);
            if (location.offset == 0) {
                --childIndex;
            }
        }
        TextLocation result = null;
        int dx = Integer.MAX_VALUE;
        Rectangle lineBounds = null;
        while (childIndex >= 0) {
            TextualEditPart part = (TextualEditPart)this.getChildren().get(childIndex);
            location = part.getNextLocation(search.recurseSearch());
            if (location != null) {
                CaretInfo caretInfo = location.part.getCaretPlacement(location.offset, false);
                if (lineBounds == null) {
                    lineBounds = new Rectangle(caretInfo.getX(), caretInfo.getY(), 0, caretInfo.getHeight());
                } else {
                    if (lineBounds.y > caretInfo.getBaseline()) break;
                    lineBounds.union(caretInfo.getX(), caretInfo.getY(), 0, caretInfo.getHeight());
                }
                int distance = Math.abs(caretInfo.getX() - search.x);
                if (distance < dx) {
                    result = location;
                    dx = distance;
                }
            }
            --childIndex;
        }
        return result;
    }

    protected TextLocation searchLineBegin(CaretSearch search) {
        int childIndex = 0;
        int childCount = this.getChildren().size();
        while (childIndex < childCount) {
            TextualEditPart newPart = (TextualEditPart)this.getChildren().get(childIndex);
            TextLocation result = newPart.getNextLocation(search.recurseSearch());
            if (result != null) {
                return result;
            }
            ++childIndex;
        }
        return null;
    }

    protected TextLocation searchLineBelow(CaretSearch search) {
        int childIndex;
        TextLocation location = search.where;
        int childCount = this.getChildren().size();
        if (location == null) {
            childIndex = 0;
        } else {
            childIndex = this.getChildren().indexOf(location.part);
            if (location.offset == location.part.getLength()) {
                ++childIndex;
            }
        }
        TextLocation result = null;
        int dx = Integer.MAX_VALUE;
        Rectangle lineBounds = null;
        search = search.recurseSearch();
        while (childIndex < childCount) {
            TextualEditPart part = (TextualEditPart)this.getChildren().get(childIndex);
            location = part.getNextLocation(search);
            if (location != null) {
                CaretInfo caretInfo = location.part.getCaretPlacement(location.offset, false);
                if (lineBounds == null) {
                    lineBounds = new Rectangle(caretInfo.getX(), caretInfo.getY(), 0, caretInfo.getHeight());
                } else {
                    if (lineBounds.bottom() < caretInfo.getBaseline()) break;
                    lineBounds.union(caretInfo.getX(), caretInfo.getY(), 0, caretInfo.getHeight());
                }
                int distance = Math.abs(caretInfo.getX() - search.x);
                if (distance < dx) {
                    result = location;
                    dx = distance;
                }
            }
            ++childIndex;
        }
        return result;
    }

    protected TextLocation searchLineEnd(CaretSearch search) {
        int childIndex = this.getChildren().size() - 1;
        while (childIndex >= 0) {
            TextualEditPart child = (TextualEditPart)this.getChildren().get(childIndex);
            TextLocation result = child.getNextLocation(search.recurseSearch());
            if (result != null) {
                return result;
            }
            --childIndex;
        }
        return null;
    }

    private int vDistanceBetween(CaretInfo info, int y) {
        if (y < info.getLineY()) {
            return info.getLineY() - y;
        }
        return Math.max(0, y - (info.getLineY() + info.getLineHeight()));
    }
}

