/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model.commands;

import org.eclipse.gef.examples.text.edit.TextualEditPart;
import org.eclipse.gef.examples.text.model.Container;
import org.eclipse.gef.examples.text.model.ModelElement;
import org.eclipse.gef.examples.text.model.ModelLocation;
import org.eclipse.gef.examples.text.model.TextRun;
import org.eclipse.gef.examples.text.model.commands.MiniEdit;

public class MergeWithPrevious
extends MiniEdit {
    private int index;
    private Container container;
    private TextRun run;

    public MergeWithPrevious(TextualEditPart part) {
        this.run = (TextRun)part.getModel();
        this.container = this.run.getContainer();
        this.index = this.container.getChildren().indexOf(this.run);
    }

    private TextRun getPreviousTextRun() {
        ModelElement candidate = (ModelElement)this.container.getChildren().get(this.index - 1);
        while (candidate instanceof Container) {
            candidate = (ModelElement)((Container)candidate).getChildren().get(((Container)candidate).size() - 1);
        }
        return (TextRun)candidate;
    }

    public void apply() {
        this.container.remove(this.run);
        TextRun previous = this.getPreviousTextRun();
        previous.insertText(this.run.getText(), previous.size());
    }

    public boolean canApply() {
        return this.index > 0;
    }

    public ModelLocation getResultingLocation() {
        TextRun previous = this.getPreviousTextRun();
        return new ModelLocation(previous, previous.size() - this.run.size());
    }

    public void rollback() {
        throw new RuntimeException("not implemented");
    }
}

