/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.requests;

import org.eclipse.gef.Request;
import org.eclipse.gef.examples.text.AppendableCommand;
import org.eclipse.gef.examples.text.SelectionRange;

public class TextRequest
extends Request {
    public static final String REQ_BACKSPACE = "TextRequest.backspace";
    public static final String REQ_BREAK = "TextRequest.breakLine";
    public static final String REQ_DELETE = "TextRequest.delete";
    public static final String REQ_INDENT = "TextRequest.indentText";
    public static final String REQ_INSERT = "TextRequest.input";
    public static final String REQ_STYLE = "TextRequest.style";
    public static final String REQ_NEW_PAGE = "TextRequest.newPage";
    public static final String REQ_NEWLINE = "TextRequest.newline";
    public static final String REQ_REMOVE_RANGE = "TextRequest.removeRange";
    public static final String REQ_UNINDENT = "TextRequest.unindentText";
    private AppendableCommand previous;
    private SelectionRange range;
    private String text;
    private String[] styleKeys;
    private Object[] styleValues;

    public TextRequest(SelectionRange range, String text, AppendableCommand prevoius) {
        super((Object)REQ_INSERT);
        this.text = text;
        this.range = range;
        this.previous = prevoius;
    }

    public TextRequest(String type, SelectionRange range) {
        this(type, range, null);
    }

    public TextRequest(String type, SelectionRange range, AppendableCommand previous) {
        super((Object)type);
        this.range = range;
        this.previous = previous;
    }

    public int getInsertionOffset() {
        return this.range.begin.offset;
    }

    public AppendableCommand getPreviousCommand() {
        return this.previous;
    }

    public SelectionRange getSelectionRange() {
        return this.range;
    }

    public String[] getStyleKeys() {
        return this.styleKeys;
    }

    public Object[] getStyleValues() {
        return this.styleValues;
    }

    public String getText() {
        return this.text;
    }

    public void setStyles(String[] keys, Object[] values) {
        this.styleKeys = keys;
        this.styleValues = values;
    }
}

