/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionGeometry;

public class PrecisionPoint
extends Point {
    public double preciseX;
    public double preciseY;

    public PrecisionPoint() {
    }

    public PrecisionPoint(double x, double y) {
        this.setPreciseLocation(x, y);
    }

    public PrecisionPoint(int x, int y) {
        this((double)x, (double)y);
    }

    public PrecisionPoint(Point p) {
        this(p.preciseX(), p.preciseY());
    }

    public boolean equals(Object o) {
        if (o instanceof PrecisionPoint) {
            PrecisionPoint p = (PrecisionPoint)o;
            return p.preciseX() == this.preciseX() && p.preciseY() == this.preciseY();
        }
        return super.equals(o);
    }

    public Point getCopy() {
        return this.getPreciseCopy();
    }

    public Dimension getDifference(Point p) {
        return new PrecisionDimension(this.preciseX() - p.preciseX(), this.preciseY() - p.preciseY());
    }

    public PrecisionPoint getPreciseCopy() {
        return new PrecisionPoint(this.preciseX(), this.preciseY());
    }

    public void performScale(double factor) {
        this.setPreciseX(this.preciseX() * factor);
        this.setPreciseY(this.preciseY() * factor);
    }

    public void performTranslate(int dx, int dy) {
        this.setPreciseX(this.preciseX() + (double)dx);
        this.setPreciseY(this.preciseY() + (double)dy);
    }

    public double preciseX() {
        this.updatePreciseXDouble();
        return this.preciseX;
    }

    public double preciseY() {
        this.updatePreciseYDouble();
        return this.preciseY;
    }

    public Point scale(double xFactor, double yFactor) {
        this.setPreciseX(this.preciseX() * xFactor);
        this.setPreciseY(this.preciseY() * yFactor);
        return this;
    }

    public Point setLocation(int x, int y) {
        return this.setPreciseLocation(x, y);
    }

    public Point setLocation(Point pt) {
        return this.setPreciseLocation(pt.preciseX(), pt.preciseY());
    }

    public PrecisionPoint setPreciseLocation(double x, double y) {
        this.setPreciseX(x);
        this.setPreciseY(y);
        return this;
    }

    public PrecisionPoint setPreciseLocation(PrecisionPoint p) {
        return this.setPreciseLocation(p.preciseX(), p.preciseY());
    }

    public PrecisionPoint setPreciseX(double x) {
        this.preciseX = x;
        this.updateXInt();
        return this;
    }

    public PrecisionPoint setPreciseY(double y) {
        this.preciseY = y;
        this.updateYInt();
        return this;
    }

    public Point setX(int x) {
        return this.setPreciseX(x);
    }

    public Point setY(int y) {
        return this.setPreciseY(y);
    }

    public Point translate(Dimension d) {
        return this.translatePrecise(d.preciseWidth(), d.preciseHeight());
    }

    public Point translate(int dx, int dy) {
        return this.translatePrecise(dx, dy);
    }

    public Point translate(Point p) {
        return this.translatePrecise(p.preciseX(), p.preciseY());
    }

    private PrecisionPoint translatePrecise(double dx, double dy) {
        this.setPreciseX(this.preciseX() + dx);
        this.setPreciseY(this.preciseY() + dy);
        return this;
    }

    public Point transpose() {
        double temp = this.preciseX();
        this.setPreciseX(this.preciseY());
        this.setPreciseY(temp);
        return this;
    }

    public final void updateInts() {
        this.updateXInt();
        this.updateYInt();
    }

    private final void updateXInt() {
        this.x = PrecisionGeometry.doubleToInteger(this.preciseX);
    }

    private final void updateYInt() {
        this.y = PrecisionGeometry.doubleToInteger(this.preciseY);
    }

    private final void updatePreciseXDouble() {
        if (this.x != PrecisionGeometry.doubleToInteger(this.preciseX)) {
            this.preciseX = this.x;
        }
    }

    private final void updatePreciseYDouble() {
        if (this.y != PrecisionGeometry.doubleToInteger(this.preciseY)) {
            this.preciseY = this.y;
        }
    }
}

