/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Rectangle;

public class Ellipse
extends Shape {
    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        Rectangle r = this.getBounds();
        long ux = x - r.x - r.width / 2;
        long uy = y - r.y - r.height / 2;
        return (ux * ux << 10) / (long)(r.width * r.width) + (uy * uy << 10) / (long)(r.height * r.height) <= 256L;
    }

    protected void fillShape(Graphics graphics) {
        graphics.fillOval(this.getBounds());
    }

    protected void outlineShape(Graphics graphics) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBounds());
        --r.width;
        --r.height;
        r.shrink((this.lineWidth - 1) / 2, (this.lineWidth - 1) / 2);
        graphics.drawOval(r);
    }
}

