/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.examples.text.SelectionModel;
import org.eclipse.gef.examples.text.SelectionRange;
import org.eclipse.gef.examples.text.TextCommand;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Caret;

public class GraphicalTextViewer
extends ScrollingGraphicalViewer {
    private SelectionModel selectionModel;

    public SelectionRange getSelectionRange() {
        if (this.selectionModel != null) {
            return this.selectionModel.getSelectionRange();
        }
        return null;
    }

    public void revealCaret() {
        Assert.isNotNull((Object)this.getControl(), (String)"The control has not been created yet.");
        Caret caret = this.getFigureCanvas().getCaret();
        if (caret == null || !caret.isVisible()) {
            return;
        }
        Viewport port = this.getFigureCanvas().getViewport();
        Rectangle view = new Rectangle(port.getViewLocation(), port.getClientArea().getSize());
        Rectangle exposeRegion = new Rectangle(caret.getBounds());
        port.getContents().translateToRelative((Translatable)exposeRegion);
        if (!view.contains(exposeRegion)) {
            int x = view.x;
            int y = view.y;
            if (exposeRegion.x < view.x) {
                x = exposeRegion.x;
            } else if (exposeRegion.right() > view.right()) {
                x = view.x + exposeRegion.right() - view.right();
            }
            if (exposeRegion.y < view.y) {
                y = exposeRegion.y;
            } else if (exposeRegion.bottom() > view.bottom()) {
                y = view.y + exposeRegion.bottom() - view.bottom();
            }
            this.getFigureCanvas().scrollTo(x, y);
        }
    }

    public void setSelectionRange(SelectionRange newRange) {
        SelectionModel newModel = null;
        if (newRange != null) {
            newModel = this.createSelectionModel(null, newRange, this.selectionModel == null ? null : this.selectionModel.getSelectedEditParts(), null);
        }
        this.setSelectionModel(newModel);
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SelectionModel selection) {
        if (selection != null) {
            selection.applySelection(this.selectionModel);
        } else if (this.selectionModel != null) {
            this.setFocus(null);
            this.selectionModel.deselect();
        }
        this.selectionModel = selection;
        this.fireSelectionChanged();
    }

    public void appendSelection(EditPart editpart) {
        if (this.focusPart != editpart) {
            this.setFocus(null);
        }
        if (this.selectionModel != null) {
            this.setSelectionModel(this.selectionModel.getAppendedSelection(editpart));
        } else {
            this.select(editpart);
        }
    }

    public void deselect(EditPart editpart) {
        if (this.selectionModel != null) {
            this.setSelectionModel(this.selectionModel.getExcludedSelection(editpart));
        }
    }

    public void deselectAll() {
        this.setSelectionModel(null);
    }

    public void select(EditPart editpart) {
        if (this.focusPart != editpart) {
            this.setFocus(null);
        }
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        list.add(editpart);
        this.setSelectionModel(this.createSelectionModel(null, null, list, null));
    }

    public void setEditDomain(EditDomain domain) {
        super.setEditDomain(domain);
        this.getEditDomain().getCommandStack().addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                if (!(event.getCommand() instanceof TextCommand) || GraphicalTextViewer.this.getSelectionRange() == null) {
                    return;
                }
                TextCommand command = (TextCommand)event.getCommand();
                if (command != null) {
                    if (event.getDetail() == 8) {
                        GraphicalTextViewer.this.setSelectionRange(command.getExecuteSelectionRange(GraphicalTextViewer.this));
                    } else if (event.getDetail() == 16) {
                        GraphicalTextViewer.this.setSelectionRange(command.getRedoSelectionRange(GraphicalTextViewer.this));
                    } else if (event.getDetail() == 32) {
                        GraphicalTextViewer.this.setSelectionRange(command.getUndoSelectionRange(GraphicalTextViewer.this));
                    }
                }
            }
        });
    }

    public void setSelection(ISelection newSelection) {
        if (newSelection != null) {
            this.setSelectionModel(this.createSelectionModel(newSelection, null, null, null));
        } else {
            this.setSelectionModel(null);
        }
    }

    public ISelection getSelection() {
        if (this.selectionModel != null) {
            return this.selectionModel.getSelection();
        }
        return new StructuredSelection((Object)this.getContents());
    }

    protected SelectionModel createSelectionModel(ISelection selection, SelectionRange range, List parts, EditPart container) {
        if (selection instanceof IStructuredSelection) {
            return new SelectionModel(selection);
        }
        return new SelectionModel(range, parts, container);
    }

    public List getSelectedEditParts() {
        return this.primGetSelectedEditParts();
    }

    protected List primGetSelectedEditParts() {
        if (this.selectionModel != null) {
            return this.selectionModel.getSelectedEditParts();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isTextSelected() {
        return this.selectionModel != null && this.selectionModel.isTextSelected();
    }

    protected LightweightSystem getLightweightSystem() {
        return super.getLightweightSystem();
    }
}

