/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.examples.text.model;

import org.eclipse.gef.examples.text.model.Notifier;

public class Style
extends Notifier {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ALIGNMENT = "alignment";
    public static final String PROPERTY_FONT = "font";
    public static final String PROPERTY_FONT_SIZE = "fontSize";
    public static final String PROPERTY_BOLD = "bold";
    public static final String PROPERTY_ITALIC = "italics";
    public static final String PROPERTY_UNDERLINE = "underline";
    public static final String PROPERTY_ORIENTATION = "orientation";
    private int alignment = 0;
    private int orientation = 0;
    private boolean bold;
    private String fontFamily;
    private int fontHeight = -1;
    private boolean italic;
    private Style parentStyle;
    private boolean underline;

    public int getAlignment() {
        if (this.alignment != 0) {
            return this.alignment;
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getAlignment();
        }
        return 0;
    }

    public String getFontFamily() {
        if (this.fontFamily != null) {
            return this.fontFamily;
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontFamily();
        }
        return "";
    }

    public int getFontHeight() {
        if (this.fontHeight != -1) {
            return this.fontHeight;
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getFontHeight();
        }
        return -1;
    }

    public int getOrientation() {
        if (this.orientation != 0) {
            return this.orientation;
        }
        if (this.parentStyle != null) {
            return this.parentStyle.getOrientation();
        }
        return 0;
    }

    public boolean isAlignedLeft() {
        return this.alignment == 1 || this.parentStyle != null && this.parentStyle.isAlignedLeft();
    }

    public boolean isBold() {
        return this.bold || this.parentStyle != null && this.parentStyle.isBold();
    }

    public boolean isItalic() {
        return this.italic || this.parentStyle != null && this.parentStyle.isItalic();
    }

    public boolean isSet(String property) {
        if (PROPERTY_BOLD.equals(property)) {
            return this.bold;
        }
        if (PROPERTY_FONT_SIZE.equals(property)) {
            return this.fontHeight != -1;
        }
        if (PROPERTY_ITALIC.equals(property)) {
            return this.italic;
        }
        if (PROPERTY_UNDERLINE.equals(property)) {
            return this.underline;
        }
        if (PROPERTY_FONT.equals(property)) {
            return this.fontFamily != null;
        }
        if (PROPERTY_ALIGNMENT.equals(property)) {
            return this.alignment != 0;
        }
        if (PROPERTY_ORIENTATION.equals(property)) {
            return this.orientation != 0;
        }
        return false;
    }

    public boolean isUnderline() {
        return this.underline || this.parentStyle != null && this.parentStyle.isUnderline();
    }

    public void setAlignment(int value) {
        if (this.alignment == value) {
            return;
        }
        if (value != 128 && value != 2 && value != 4 && value != 0 && value != 1 && value != 64) {
            throw new IllegalArgumentException("Alignment must be LEFT, CENTER, RIGHT, ALWAYS_LEFT, ALWAYS_RIGHT or NONE.");
        }
        int oldValue = this.alignment;
        this.alignment = value;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_ALIGNMENT, oldValue, this.alignment);
        }
    }

    public void setBold(boolean value) {
        if (this.bold == value) {
            return;
        }
        this.bold = value;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_BOLD, !value, value);
        }
    }

    public void setFontFamily(String fontFamily) {
        String oldName = this.fontFamily;
        this.fontFamily = fontFamily;
        this.firePropertyChange(PROPERTY_FONT, oldName, fontFamily);
    }

    public void setFontHeight(int fontHeight) {
        this.fontHeight = fontHeight;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_FONT_SIZE, fontHeight, fontHeight);
        }
    }

    public void setItalic(boolean value) {
        if (this.italic == value) {
            return;
        }
        this.italic = value;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_ITALIC, !value, value);
        }
    }

    public void setOrientation(int value) {
        if (this.orientation == value) {
            return;
        }
        if (value != 0x4000000 && value != 0x2000000 && value != 0) {
            throw new IllegalArgumentException("Orientation must LTR, RTL or NONE.");
        }
        int oldValue = this.orientation;
        this.orientation = value;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_ORIENTATION, oldValue, this.orientation);
        }
    }

    public void setParentStyle(Style style) {
        this.parentStyle = style;
    }

    public void setUnderline(boolean value) {
        if (this.underline == value) {
            return;
        }
        this.underline = value;
        if (this.listeners != null) {
            this.listeners.firePropertyChange(PROPERTY_UNDERLINE, !value, value);
        }
    }
}

